package com.ydl.ydlcommon.utils;

import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.data.PlatformDataManager;
import com.ydl.ydlcommon.data.http.BaseCommand;
import com.ydl.ydlcommon.data.http.FormatText;
import com.ydl.ydlcommon.modular.ModularServiceManager;
import com.ydl.ydlcommon.router.YdlCommonRouterManager;
import com.ydl.ydlcommon.router.YdlUserInfo;
import com.yidianling.common.tools.RxAppTool;
import com.yidianling.common.tools.RxDeviceTool;
import okhttp3.MediaType;
import okhttp3.RequestBody;

import java.io.File;
import java.lang.reflect.Field;
import java.util.*;

/**
 * Created by haorui on 2019-09-19.
 * Des:
 */
public class NetworkParamsUtils {

    public static List<FormatText> getPostList(BaseCommand crq) {
        List<FormatText> formTextList = new ArrayList<>();
        Field[] fields = crq.getClass().getFields();
        for (Field field : fields) {
            try {
                boolean accessFlag = field.isAccessible();
                field.setAccessible(true);
                Object o = field.get(crq);
                if (o != null) {
                    FormatText formatText;
                    formatText = new FormatText(field.getName(), String.valueOf(o));
                    formTextList.add(formatText);
                }
                field.setAccessible(accessFlag);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return formTextList;
    }


    //获取网络请求表
    public static Map<String, String> getMaps(List<FormatText> list) {
        Map<String, String> map = new HashMap<>();
        int size = list.size();
        for (int i = 0; i < size; i++) {
            FormatText formatText = list.get(i);
            map.put(formatText.getmKey(), String.valueOf(formatText.getmValue()));
        }
        return map;
    }


    //获取网络请求表
    public static Map<String, String> getMaps(BaseCommand cmd) {
        Map<String, String> map = new HashMap<>();
        List<FormatText> list = getPostList(cmd);
        int size = list.size();
        for (int i = 0; i < size; i++) {
            FormatText formatText = list.get(i);
            map.put(formatText.getmKey(), String.valueOf(formatText.getmValue()));
        }
        return map;
    }

    //获取文件传输网络请求表
    @SuppressWarnings("unused")
    public static Map<String, RequestBody> getFileMaps(BaseCommand cmd, String key, File[] files) {
        Map<String, RequestBody> map = new TreeMap<>();
        List<FormatText> list = getPostList(cmd);
        int size = list.size();
        for (int i = 0; i < size; i++) {
            FormatText formatText = list.get(i);
//            RequestBody rb = RequestBody.create(MediaType.parse("multipart/form-data"),list.get(i).getmValue());
            RequestBody rb = RequestBody.create(MediaType.parse("text/plain"), String.valueOf(list.get(i).getmValue()));
            map.put(formatText.getmKey(), rb);
        }

        if (files != null && files.length > 0) {
            if (files.length == 1) {
                if (files[0] != null) {
                    RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), files[0]);
                    map.put(key + "\"; filename=\"" + files[0].getName() + "", fileBody);
                }
            } else {
                for (int i = 0; i < files.length; i++) {
                    if (files[i] != null) {
                        RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), files[i]);
                        map.put(key + i + "\"; filename=\"" + files[i].getName() + "", fileBody);
                    }
                }
            }

        }
        return map;
    }


    //获取网络请求表
    private static Map<String, RequestBody> getFileMaps(List<FormatText> list, String key, File[] file) {
        Map<String, RequestBody> map = new TreeMap<>();
        int size = list.size();
        for (int i = 0; i < size; i++) {
            FormatText formatText = list.get(i);
//            RequestBody rb = RequestBody.create(MediaType.parse("multipart/form-data"),list.get(i).getmValue());
            RequestBody rb = RequestBody.create(MediaType.parse("text/plain"), String.valueOf(list.get(i).getmValue()));
            map.put(formatText.getmKey(), rb);
        }

        if (file != null && file.length > 0) {
            if (file.length == 1) {
                if (file[0] != null) {
                    RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), file[0]);
                    map.put(key + "\"; filename=\"" + file[0].getName() + "", fileBody);
                }
            } else {
                for (int i = 0; i < file.length; i++) {
                    if (file[i] != null) {
                        RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), file[i]);
                        map.put(key + i + "\"; filename=\"" + file[i].getName() + "", fileBody);
                    }
                }
            }

        }
        return map;
    }

    public static String getCommonParam() {
        StringBuffer sb = new StringBuffer();
        YdlUserInfo userInfo = ModularServiceManager.INSTANCE.getPlatformUserService().getUser();
        sb.append("ffrom").append("=").append(PlatformDataManager.INSTANCE.getRam().getChannelName())
                .append("&").append("isFromApp").append("=").append("1")
                .append("&").append("osBuild").append("=").append(RxDeviceTool.getBuildBrandModel()).append(",")
                .append(RxDeviceTool.getSDKVersionName()).append(",").append(RxAppTool.getAppVersionName(BaseApp.Companion.getApp()))
                .append("&").append("ts").append("=").append(System.currentTimeMillis() / 1000)
                .append("&").append("version").append("=").append(RxAppTool.getAppVersionName(BaseApp.Companion.getApp()));
        if (null != userInfo) {
            sb.append("&").append("uid").append("=").append(userInfo.getUserId())
                    .append("&").append("accessToken").append("=").append(userInfo.getToken());
        }
        return sb.toString();
    }
}

