package com.ydl.ydlcommon.utils

import android.app.DownloadManager
import android.content.Context
import android.net.Uri
import java.io.File


/**
 * 使用系统下载服务下载文件
 */
class SystemDownloadFileUtil(var context : Context){

    var fileUrl : String? = null
    var mTitle : String? = null
    var desc : String? = null
    var mVersion : String? = null

    companion object {

        private var systemDownloadFileUtil : SystemDownloadFileUtil? = null

        @Synchronized
        fun getInstances(context: Context): SystemDownloadFileUtil {
            return systemDownloadFileUtil
                ?: SystemDownloadFileUtil(context)
        }
    }

    fun setUrl(str : String?): SystemDownloadFileUtil {
        this.fileUrl = str
        return this
    }

    fun setTitle(str : String?){
        this.mTitle = str
    }

    fun setVersion(ver:String?): SystemDownloadFileUtil {
        this.mVersion = ver
        return this
    }

    fun start():Long{
        fileUrl?:return 0
        val request = DownloadManager.Request(Uri.parse(fileUrl))

        /*
         * 设置在通知栏是否显示下载通知(下载进度), 有 3 个值可选:
         *    VISIBILITY_VISIBLE:                   下载过程中可见, 下载完后自动消失 (默认)
         *    VISIBILITY_VISIBLE_NOTIFY_COMPLETED:  下载过程中和下载完成后均可见
         *    VISIBILITY_HIDDEN:                    始终不显示通知
         */
        request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);

        // 设置通知的标题和描述
        request.setTitle(mTitle)
        request.setDescription(desc)
        // 设置下载文件的保存位置
        val saveFile = File(FileUtil2.getLocalStorePath("download"), "ydl-user-$mVersion.apk")
        request.setDestinationUri(Uri.fromFile(saveFile))


        /*
         * 2. 获取下载管理器服务的实例, 添加下载任务
         */
        val manager = context.getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager

        // 将下载请求加入下载队列, 返回一个下载ID
        val downloadId = manager.enqueue(request)
        return downloadId
    }

    fun query(downloadId: Long?) {
        downloadId?:return
        // 获取下载管理器服务的实例
        val manager =context.getSystemService (Context.DOWNLOAD_SERVICE) as DownloadManager

        // 创建一个查询对象
        var query = DownloadManager.Query()

        // 根据 下载ID 过滤结果
        query.setFilterById(downloadId)

        // 还可以根据状态过滤结果
        // query.setFilterByStatus(DownloadManager.STATUS_SUCCESSFUL);

        // 执行查询, 返回一个 Cursor (相当于查询数据库)
        var cursor = manager.query(query)

        if (!cursor.moveToFirst()) {
            cursor.close()
            return
        }

        // 下载ID
        var id = cursor.getLong(cursor.getColumnIndex(DownloadManager.COLUMN_ID))
        // 下载请求的状态
        var status = cursor.getInt (cursor.getColumnIndex(DownloadManager.COLUMN_STATUS))
        // 下载文件在本地保存的路径（Android 7.0 以后 COLUMN_LOCAL_FILENAME 字段被弃用, 需要用 COLUMN_LOCAL_URI 字段来获取本地文件路径的 Uri）
        val localFilename = cursor.getString(cursor.getColumnIndex(DownloadManager.COLUMN_LOCAL_URI))
        // 已下载的字节大小
        var downloadedSoFar = cursor.getLong(cursor.getColumnIndex(DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR))
        // 下载文件的总字节大小
        var totalSize = cursor.getLong(cursor.getColumnIndex(DownloadManager.COLUMN_TOTAL_SIZE_BYTES))

        cursor.close()

//        System.out.println("下载进度: " + downloadedSoFar + "/" + totalSize);

        /*
         * 判断是否下载成功，其中状态 status 的值有 5 种:
         *     DownloadManager.STATUS_SUCCESSFUL:   下载成功
         *     DownloadManager.STATUS_FAILED:       下载失败
         *     DownloadManager.STATUS_PENDING:      等待下载
         *     DownloadManager.STATUS_RUNNING:      正在下载
         *     DownloadManager.STATUS_PAUSED:       下载暂停
         */
        if (status == DownloadManager.STATUS_SUCCESSFUL) {
            /*
             * 特别注意: 查询获取到的 localFilename 才是下载文件真正的保存路径，在创建
             * 请求时设置的保存路径不一定是最终的保存路径，因为当设置的路径已是存在的文件时，
             * 下载器会自动重命名保存路径，例如: .../demo-1.apk, .../demo-2.apk
             */
//            System.out.println("下载成功, 打开文件, 文件路径: " + localFilename);

        }
    }

    fun cancel(downLoadId : Long?){
        downLoadId?:return
        val manager = context.getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
        manager.remove(downLoadId)
    }
}