package com.ydl.ydlcommon.utils;

import java.util.HashMap;

/**
 * Created by jiucheng on 2018/5/9.
 * 功能：页面跳转时传递较大的数据
 */

public class TransferCacheUtils {
    private static HashMap<Object, Object> cache = new HashMap<>();

    public static void putTransferData(Object key, Object value) {
        if (key != null && value != null) {
            cache.put(key, value);
        }
    }

    public static Object getTransferData(Object key) {
        if (key != null && cache != null) {
            try {
                return cache.get(key);
            } catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static int getTransferDataForInt(Object key) {
        if (key != null && cache != null) {
            try {
                Object o = cache.get(key);
                if (o != null) {
                    return (int) cache.get(key);
                }
                return -1;
            } catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public static Object removeTransferData(Object key) {
        if (key != null && cache != null) {
            try {
                return cache.remove(key);
            } catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}
