package com.ydl.ydlcommon.utils

import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import java.util.concurrent.TimeUnit

/**
 * @author yuanwai
 * @描述:异步工具类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/27
 */
class YDLAsyncUtils{
    companion object{
        fun asyncAsResult(asyncObjecyer: AsyncObjecyerResult) {
            Observable.just(asyncObjecyer).subscribeOn(Schedulers.io()).map {
                asyncObjecyer.doAsyncAction()
            }.observeOn(AndroidSchedulers.mainThread()).subscribe({ o ->
                asyncObjecyer.asyncResult(o)
            }) {
                asyncObjecyer.asyncResult(null)
            }
        }

        fun async(asyncObjecyer: AsyncObjecyer) {
            Observable.just(asyncObjecyer).subscribeOn(Schedulers.io()).map { asyncObjecyer ->
                asyncObjecyer.doAsyncAction()
                true
            }.observeOn(AndroidSchedulers.mainThread()).subscribe({ }) { }
        }

        fun delayAsync(asyncObjecyer: AsyncObjecyer, delay: Long) {
            Observable.timer(delay, TimeUnit.SECONDS).subscribe {
                async(
                    asyncObjecyer
                )
            }
        }
    }

    interface AsyncObjecyer {
        fun doAsyncAction()
    }

    interface AsyncObjecyerResult {
        fun doAsyncAction(): Any
        fun asyncResult(`object`: Any?)
    }
}
