package com.ydl.ydlcommon.utils.extend

import android.view.View
import android.widget.TextView
import androidx.annotation.DrawableRes

fun View?.gone() {
    this?.visibility = View.GONE
}

fun View?.visible() {
    this?.visibility = View.VISIBLE
}

fun View?.invisible() {
    this?.visibility = View.INVISIBLE
}

fun TextView?.leftDrawable(@DrawableRes left: Int) {
    this?.setCompoundDrawablesWithIntrinsicBounds(left, 0, 0, 0)
}

fun TextView?.topDrawable(@DrawableRes top: Int) {
    this?.setCompoundDrawablesWithIntrinsicBounds(0, top, 0, 0)
}

fun TextView?.rightDrawable(@DrawableRes right: Int) {
    this?.setCompoundDrawablesWithIntrinsicBounds(0, 0, right, 0)
}

fun TextView?.bottomDrawable(@DrawableRes bottom: Int) {
    this?.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, bottom)
}

fun TextView?.drawable(@DrawableRes left: Int = 0, @DrawableRes top: Int = 0, @DrawableRes right: Int = 0, @DrawableRes bottom: Int = 0) {
    this?.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom)
}
