package com.ydl.ydlcommon.view.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.R;


public class ThreeLinesDialog extends Dialog {

	private Context mContext;

	public ThreeLinesDialog(Context context) {
		super(context);
		mContext = context;
	}

	public ThreeLinesDialog(Context context, int theme) {
		super(context, theme);
		mContext = context;
	}

	public static class Builder {
		//是否可以点击对话框外部
//		Boolean flag=true;
		private Context context; //上下文对象
		private String title; //对话框标题
		private String message; //对话框内容
		private String confirm_btnText; //按钮名称“确定”
//		private String cancel_btnText; //按钮名称“取消”
		private View contentView; //对话框中间加载的其他布局界面
		/*按钮坚挺事件*/
//		private OnClickListener confirm_btnClickListener;

		private OnClickListener first_btnClickListener;
		private OnClickListener send_btnClickListener;
		private OnClickListener thirid_btnClickListener;

		public Builder(Context context) {
			this.context = context;
		}

		/*设置对话框信息*/
		public Builder setMessage(String message) {
			this.message = message;
			return this;
		}

		/**
		 * Set the Dialog message from resource
		 * 
		 * @param message
		 * @return
		 */
		public Builder setMessage(int message) {
			this.message = (String) context.getText(message);
			return this;
		}

		/**
		 * Set the Dialog title from resource
		 * 
		 * @param title
		 * @return
		 */
		public Builder setTitle(int title) {
			this.title = (String) context.getText(title);
			return this;
		}

		/**
		 * Set the Dialog title from String
		 * @param title
		 * @return
		 */
		public Builder setTitle(String title) {
			this.title = title;
			return this;
		}


		public Builder setbottom(int bottom) {
			this.confirm_btnText = (String) context.getText(bottom);
			return this;
		}


		public Builder setbottom(String bottom) {
			this.confirm_btnText = bottom;
			return this;
		}

//		public Builder setCanceledOnTouchOutside(Boolean flag){
//			this.setCanceledOnTouchOutside(flag);
//			return this;
//		}
		/**
		 * 设置对话框界面
		 * @param v View
		 * @return
		 */
		public Builder setContentView(View v) {
			this.contentView = v;
			return this;
		}

//		/**
//		 * Set the positive button resource and it's listener
//		 * @param confirm_btnText
//		 * @return
//		 */
//		public Builder setPositiveButton(int confirm_btnText,
//				OnClickListener listener) {
//			this.confirm_btnText = (String) context
//					.getText(confirm_btnText);
//			this.confirm_btnClickListener = listener;
//			return this;
//		}
//
//		/**
//		 * Set the positive button and it's listener
//		 * @param confirm_btnText
//		 * @return
//		 */
//		public Builder setPositiveButton(String confirm_btnText,
//				OnClickListener listener) {
//			this.confirm_btnText = confirm_btnText;
//			this.confirm_btnClickListener = listener;
//			return this;
//		}


		public Builder setFirstButton(int confirm_btnText,
										 OnClickListener listener) {
			this.title = (String) context
					.getText(confirm_btnText);
			this.first_btnClickListener = listener;
			return this;
		}


		public Builder setFirstButton(String confirm_btnText,
										 OnClickListener listener) {
			this.title = confirm_btnText;
			this.first_btnClickListener = listener;
			return this;
		}

		public Builder setSecondButton(int confirm_btnText,
									  OnClickListener listener) {
			this.message = (String) context
					.getText(confirm_btnText);
			this.send_btnClickListener = listener;
			return this;
		}


		public Builder setSecondButton(String confirm_btnText,
									  OnClickListener listener) {
			this.message = confirm_btnText;
			this.send_btnClickListener = listener;
			return this;
		}

		public Builder setThridButton(int confirm_btnText,
									   OnClickListener listener) {
			this.confirm_btnText = (String) context
					.getText(confirm_btnText);
			this.thirid_btnClickListener = listener;
			return this;
		}


		public Builder setThridButton(String confirm_btnText,
									   OnClickListener listener) {
			this.confirm_btnText = confirm_btnText;
			this.thirid_btnClickListener = listener;
			return this;
		}

		public ThreeLinesDialog create() {
			LayoutInflater inflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			// instantiate the dialog with the custom Theme
			final ThreeLinesDialog dialog = new ThreeLinesDialog(context, R.style.platform_normaldialog_style);
			View layout;
			layout = inflater.inflate(R.layout.platform_dialog_trend_layout, null);
			
			dialog.addContentView(layout, new LayoutParams(
					LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
			if(title!=null){
				// set the dialog title
				((TextView) layout.findViewById(R.id.title)).setText(title);
//				((TextView) layout.findViewById(R.id.title)).getPaint().setFakeBoldText(true);
				if(first_btnClickListener!=null){
					((TextView) layout.findViewById(R.id.title)).setOnClickListener(new View.OnClickListener() {
						@Override
						public void onClick(View v) {
							first_btnClickListener.onClick(dialog,
									DialogInterface.BUTTON_POSITIVE);
						}
					});
				}
			}else {
				((TextView) layout.findViewById(R.id.title)).setVisibility(View.GONE);
			}

			// set the confirm button
			if (confirm_btnText != null) {
				((TextView) layout.findViewById(R.id.confirm_btn))
						.setText(confirm_btnText);
				if (thirid_btnClickListener != null) {
					((TextView) layout.findViewById(R.id.confirm_btn))
							.setOnClickListener(new View.OnClickListener() {
								public void onClick(View v) {
									thirid_btnClickListener.onClick(dialog,
											DialogInterface.BUTTON_POSITIVE);
								}
							});
				}
			} else {
				// if no confirm button just set the visibility to GONE
				layout.findViewById(R.id.confirm_btn).setVisibility(
						View.GONE);
			}


			// set the content message
			if (message != null) {
				((TextView) layout.findViewById(R.id.message)).setText(message);
				if (send_btnClickListener != null) {
					((TextView) layout.findViewById(R.id.message))
							.setOnClickListener(new View.OnClickListener() {
								public void onClick(View v) {
									send_btnClickListener.onClick(dialog,
											DialogInterface.BUTTON_POSITIVE);
								}
							});
				}
			} else if (contentView != null) {
				// if no message set
				// add the lceContentView to the dialog body
				((RelativeLayout) layout.findViewById(R.id.message_layout)).removeAllViews();
				((RelativeLayout) layout.findViewById(R.id.message_layout)).addView(
						contentView, new LayoutParams(
								LayoutParams.WRAP_CONTENT,
								LayoutParams.WRAP_CONTENT));

			}else {
				((TextView) layout.findViewById(R.id.message)).setVisibility(View.GONE);
			}
			dialog.setContentView(layout);
			dialog.setCanceledOnTouchOutside(true);
			return dialog;
		}

	}

	@Override
	public void show() {
		if (null == mContext){
			return;
		}
		if (mContext instanceof Activity) {
			if (((Activity) mContext).isFinishing()) {
				return;
			}
		}
		super.show();
	}
}
