package com.tencent.qcloud.tuicore.calling.videocall;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.blankj.utilcode.util.ToastUtils;
import com.tencent.qcloud.tuicore.R;
import com.tencent.qcloud.tuicore.calling.basic.ImageLoader;
import com.tencent.qcloud.tuicore.calling.basic.UserModel;
import com.tencent.qcloud.tuicore.calling.trtccalling.model.TRTCCalling;
import com.tencent.qcloud.tuicore.calling.trtccalling.model.impl.base.CallingInfoManager;
import com.tencent.qcloud.tuicore.calling.trtccalling.ui.common.RoundCornerImageView;
import com.tencent.qcloud.tuicore.event.ClearJPushEvent;
import com.tencent.qcloud.tuicore.util.MDTRxActivityTool;
import com.tencent.qcloud.tuicore.util.StatusBarUtil;

import de.greenrobot.event.EventBus;

/**
 * @Author:      刘鹏
 * @Description: 音视频接听界面
 * @CreateDate:  2022/4/19 19:35
 * -------------------------------
 * @UpdateUser:
 * @UpdateDate:  2022/4/19 19:35
 * @UpdateRemark:
 * @Version:
 */
public class YDLInvitionActivity extends TRTCBaseActivity {
    private static final int ERROR_CODE_USER_NOT_EXIST = 206;

    private String mRoomId;
    private String mUserId;
    /**头像*/
    private RoundCornerImageView mIvAvatar;
    /**名字*/
    private TextView mTvName;
    /**拒绝*/
    private ImageView mIvVideoInviteRefuse;
    /**接听*/
    private ImageView mIvVideoInviteAccept;
    private String mInviteId;
    /**邀请人信息*/
    private UserModel mInviteModel;

    @Override
    protected void onPermissionGranted() {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBarUtil.transparencyBar(this);
        MDTRxActivityTool.addActivity(this);
        handleIntent();
        setContentView(R.layout.video_invition_activity);
        TRTCCalling trtcCalling = TRTCCalling.sharedInstance(this);
        // 响铃
        trtcCalling.startRing();
        // 正在被邀请
        trtcCalling.mIsBeingInvited = true;
        // 清除TRTCCalling类中记录的邀请信息
        trtcCalling.mRoomId = "";
        trtcCalling.mUserId = "";
        trtcCalling.mInviteId = "";
        // 发送清空通知栏的通知
        EventBus.getDefault().post(new ClearJPushEvent());
        initView();
    }

    private void handleIntent() {
        Intent intent = getIntent();
        if (null != intent) {
            if (intent.getStringExtra(Constant.USER_ID) != null) {
                mUserId = intent.getStringExtra(Constant.USER_ID);
            }
            if (intent.getStringExtra(Constant.ROOM_ID) != null) {
                mRoomId = intent.getStringExtra(Constant.ROOM_ID);
            }
            if (intent.getStringExtra(Constant.INVITE_ID) != null) {
                mInviteId = intent.getStringExtra(Constant.INVITE_ID);
            }
        }

        CallingInfoManager.getInstance().getUserInfoByUserId(mInviteId, new CallingInfoManager.UserCallback() {
            @Override
            public void onSuccess(UserModel model) {
                mInviteModel = new UserModel();
                mInviteModel.userId = model.userId;
                mInviteModel.userName = TextUtils.isEmpty(model.userName) ? model.userId : model.userName;
                showSearchUserModel(mInviteModel);
            }

            @Override
            public void onFailed(int code, String msg) {
                showSearchUserModel(null);
                if (code == ERROR_CODE_USER_NOT_EXIST) {
                    ToastUtils.showLong("用户不存在");
                } else {
                    ToastUtils.showLong(getString(R.string.trtccalling_toast_search_fail, msg));
                }
            }
        });
    }

    private void initView() {
        mIvAvatar = findViewById(R.id.iv_avatar);
        mTvName = findViewById(R.id.tv_name);
        mIvVideoInviteAccept = findViewById(R.id.iv_video_invite_accept);

        mIvVideoInviteRefuse = findViewById(R.id.iv_video_invite_refuse);
        //接听
        mIvVideoInviteAccept.setOnClickListener(v -> {
            // 接听后停止响铃
            TRTCCalling.sharedInstance(YDLInvitionActivity.this).stopRing();
            TRTCCalling.sharedInstance(YDLInvitionActivity.this).mdtCallBack.onInviteeAccepted(mRoomId);
            Intent intent = new Intent(YDLInvitionActivity.this, VideoCallingActivity.class);
            intent.putExtra(Constant.ROOM_ID, mRoomId);
            intent.putExtra(Constant.USER_ID, mUserId);
            startActivity(intent);
            finish();
        });
        //拒绝
        mIvVideoInviteRefuse.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                TRTCCalling.sharedInstance(YDLInvitionActivity.this).reject();
                TRTCCalling.sharedInstance(YDLInvitionActivity.this).mdtCallBack.onInviteeRejected(mRoomId);
                finish();
            }
        });
    }

    private void showSearchUserModel(UserModel model) {
        if (null == model) {
            return;
        }
        ImageLoader.loadImage(this, mIvAvatar, model.userAvatar, R.drawable.ic_avatar);
        if (model.userName!=null) {
            mTvName.setText(model.userName);
        }
    }

    @Override
    public void onBackPressed() {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MDTRxActivityTool.removeActivity(this);
        // 被邀请结束
        TRTCCalling.sharedInstance(this).mIsBeingInvited = false;
    }
}
