package com.yidianling.common.tools;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.StringRes;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.yidianling.common.tools.support.toast.ToastCompat;

/**
 * 显示Toast工具类
 * Created by Dog on 2015/4/4.
 */
public class ToastUtil {


    private static String oldMsg;
    private static Handler handler;
    protected static Toast toast = null;
    private static long oneTime = 0;
    private static long twoTime = 0;

    public static void toastShort(Context context, @StringRes Integer resourceId ) {
        toastShort(resourceId);
    }

    public static void toastShort(@StringRes Integer resourceId ) {
        try {
            String text = RxTool.getContext().getResources().getString(resourceId);
            toastShort(text);
        } catch (Exception e) {
            LogUtil.i(e.getMessage());
        }
    }

    public static void toastShort(Context context, String message) {
        safeToast(message);
    }

    public static void toastShort(String msg) {
        safeToast(msg);
    }

    private static void safeToast(String msg) {
        if(Looper.myLooper() == Looper.getMainLooper()) {
            showShortToast(RxTool.getContext(), msg);
        }else {
            //说明不是在主线程
            if (handler == null) {
                handler = new Handler(Looper.getMainLooper());
            }
            handler.post(() -> toastShort(RxTool.getContext(), msg));
        }
    }

    private static void showShortToast(Context mContext, String msg) {
        if (toast == null) {
            toast = ToastCompat.makeText(mContext.getApplicationContext(), msg, Toast.LENGTH_SHORT);
            centerText(toast.getView());
            toast.show();
            oneTime = System.currentTimeMillis();
        } else {
            twoTime = System.currentTimeMillis();
            if (msg.equals(oldMsg)) {
                if (twoTime - oneTime > Toast.LENGTH_SHORT) {
                    centerText(toast.getView());
                    toast.show();
                }
            } else {
                oldMsg = msg;
                toast.setText(msg);
                centerText(toast.getView());
                toast.show();
            }
        }
        oneTime = twoTime;
    }


    private static View getView(Context context, Toast toast, String message) {
        View toastView = toast.getView();
        //创建一个ImageView
        TextView textView = new TextView(context);
        textView.setText(message);
        //创建一个LineLayout容器
        LinearLayout ll = new LinearLayout(context);
        ll.setGravity(Gravity.CENTER);
        ll.setPadding(20, 10, 20, 10);
        //向LinearLayout中添加ImageView和Toast原有的View
        ll.addView(textView);
        //ll.addView(toastView);
        //将LineLayout容器设置为toast的View
        return toastView;
    }

    public static void toastShortBottom(Context context, String message) {
        if (context != null) {
            Toast toast = ToastCompat.makeText(context, message, Toast.LENGTH_SHORT);
            centerText(toast.getView());
            toast.show();
        }
    }

    public static void toastLong(Context context, String message) {
        if (context != null) {
            Toast toast = ToastCompat.makeText(context, message, Toast.LENGTH_LONG);
            toast.setGravity(Gravity.CENTER, 0, 0);
            centerText(toast.getView());
            toast.show();

        }
    }

    public static void toastImg(Context context, int ImageResourceId) {
        //创建一个Toast提示消息
        Toast toast = ToastCompat.makeText(context, "", Toast.LENGTH_SHORT);
        //设置Toast提示消息在屏幕上的位置
        toast.setGravity(Gravity.CENTER, 0, 0);
        //获取Toast提示消息里原有的View
        View toastView = toast.getView();
        //创建一个ImageView
        ImageView img = new ImageView(context);
        img.setImageResource(ImageResourceId);
        //创建一个LineLayout容器
        LinearLayout ll = new LinearLayout(context);
        //向LinearLayout中添加ImageView和Toast原有的View
        ll.addView(img);
        //ll.addView(toastView);
        //将LineLayout容器设置为toast的View
        toast.setView(ll);
        //显示消息
        toast.show();
    }

    static void centerText(View view) {
        if (view instanceof TextView) {
            ((TextView) view).setGravity(Gravity.CENTER);
            view.setPadding(20, 10, 20, 10);
        } else if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup) view;

            if (view instanceof LinearLayout) {
                ((LinearLayout) view).setGravity(Gravity.CENTER);
            }
            int n = group.getChildCount();
            for (int i = 0; i < n; i++) {
                centerText(group.getChildAt(i));
            }
        }
    }


}
