package com.ydl.view

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.text.TextUtils
import android.view.View
import android.widget.PopupWindow
import android.widget.RelativeLayout
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.webview.IJavascriptHandler
import com.ydl.webview.R
import com.ydl.ydlcommon.base.config.ChannelConfig
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.YdlCommonRouterManager
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.im.api.service.IImService
import kotlinx.android.synthetic.main.web_ui_new_more.view.*

/**
 * Created by Wi1ls on 2016/10/17;
 */
class MoreClickView(context: Context, jtoJHandle: IJavascriptHandler) : RelativeLayout(context),
    View.OnClickListener {
    private var mJtoJHandle: IJavascriptHandler? = jtoJHandle
    private var mPopupWindow: PopupWindow? = null

    private val work_time = if (PlatformDataManager.getRam()
            .getGlobalInfo() == null
    ) "早8:30-凌晨2:00" else PlatformDataManager.getRam().getGlobalInfo()?.info?.work_time
    private val tel = if (PlatformDataManager.getRam()
            .getGlobalInfo() == null
    ) "400-765-1010" else PlatformDataManager.getRam().getGlobalInfo()?.info?.tel

    init {
        View.inflate(context, R.layout.web_ui_new_more, this)
        init()
    }

    internal fun init() {
        if (mJtoJHandle?.setMoreMsg() != null) {
            more_msg.setOnClickListener(mJtoJHandle?.setMoreMsg())
        } else {
            more_msg.setOnClickListener(this)
        }
        if (mJtoJHandle?.setMoreHomePage() != null) {
            more_homepage.setOnClickListener(mJtoJHandle?.setMoreHomePage())
        } else {
            more_homepage.setOnClickListener(this)
        }
        if (mJtoJHandle?.setMoreService() != null) {
            more_service.setOnClickListener(mJtoJHandle?.setMoreService())
        } else {
            more_service.setOnClickListener(this)
        }
        if (mJtoJHandle?.setMoreCall() != null) {
            more_ray.setOnClickListener(mJtoJHandle?.setMoreCall())
        } else {
            more_ray.setOnClickListener(this)
        }
        more_feed.setOnClickListener(this)
/*        if (YdlCommonRouterManager.getYdlCommonRoute().isHasUnread()) {
            msg_new.setVisibility(View.VISIBLE)
        } else {
            msg_new.setVisibility(View.INVISIBLE)
        }*/

        val unreadNum = ModularServiceManager.provide(IImService::class.java).getAllUnReadNum()
        if (unreadNum <= 0) {
            un_read_num.visibility = View.GONE
        } else {
            if (unreadNum > 99) {
                un_read_num.text = "${unreadNum}+"
            } else {
                un_read_num.text = unreadNum.toString()
            }
        }

    }


    override fun onClick(view: View) {
        if (mPopupWindow != null && mPopupWindow!!.isShowing) {
            mPopupWindow!!.dismiss()
        }
        when (view.id) {
            R.id.more_msg -> {
                setMoreMsg()
            }
            R.id.more_homepage -> {
                setMoreHomePage()
            }
            R.id.more_service -> {
                setMoreService()
            }
            R.id.more_ray -> {
                setMoreRay()
            }
            R.id.more_feed -> {
                ARouter.getInstance().build("/mine/FeedBackActivity").navigation()
            }
        }

    }

    private fun setMoreMsg() {
        if (PlatformDataManager.getRam().getChannelName().startsWith(ChannelConfig.ATK_3.name)) {
            YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 2, null)
        } else {
            YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 3, null)
        }
    }

    private fun setMoreHomePage() {
        YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 0, null)
    }

    private fun setMoreService() {
        YdlCommonRouterManager.getYdlCommonRoute().setMoreService(context)
    }

    private fun setMoreRay() {
        CommonDialog(context)
            .setMessage("欢迎致电壹点灵客服热线\n$tel\n服务时间:$work_time")
            .setLeftOnclick("取消", null)
            .setRightClick("拨打") {
                if (null != tel && !TextUtils.isEmpty(tel)) {
                    val phoneIntent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:$tel"))
                    context.startActivity(phoneIntent)
                }
            }.show()
    }

    fun setPopupWindow(popupWindow: PopupWindow) {
        mPopupWindow = popupWindow
    }
}
