package com.ydl.webview

import com.ydl.ydlcommon.bean.ShareData
import java.io.Serializable

/**
 * 跳转到h5页面所需参数
 * Created by Administrator on 2017/8/3 0003.
 */
class H5Params : Serializable {

    constructor(url: String, title: String?) : super() {
        this.url = url
        this.title = title
    }

    constructor(url: String, backLimit: BackLimit, hasBackLimit: Boolean): super() {
        this.url =url
        if (hasBackLimit) {
            this.backLimit = backLimit
        }
    }

    constructor(url: String, title: String?, share: ShareData?) : super() {
        this.url = url
        this.shareData = share
        this.title = title
    }

    constructor(url: String, title: String?, share: ShareData?, showUrlTitle: Boolean, suffix: Boolean) : super() {
        this.url = url
        this.shareData = share
        this.title = title
        this.showUrlTitle = showUrlTitle
        this.suffix = suffix
    }

    var title: String? = null
    var url: String = ""

    /**
     * 分享参数
     */
    var shareData: ShareData? = null

    /**
     * 是否显示右上角菜单
     */
    var isShowMenu = false
    /**
     * 是否加签 默认加签
     */
    var suffix = true
    /**
     * 是否显示title
     */
    var showUrlTitle = true
    /**
     * 是否从启动页进入
     */
    var isSplash = false
    /**
     * 高级题测试题流程：是否要控制物理返回键逻辑
     */
    var isControlBack = false
    /**
     * 倾诉拨打电话
     */
    var phone: String? = null
    /**
     * h5页面返回按钮限制
     */
    var backLimit: BackLimit? = null

    enum class BackLimit {
        NEW_USER_PAGE  // 新用户引导页面
    }

}