
package com.ydl.component.base;

import android.content.Context;

import com.ydl.component.BuildConfig;
import com.ydl.ydlcommon.base.config.IConfigModule;
import com.ydl.ydlcommon.base.config.YDLConstants;
import com.ydl.ydlcommon.base.delegate.IAppLifecycles;
import com.ydl.ydlcommon.base.config.GlobalConfig;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Created by haorui on 2019-09-01 .
 * Des:
 */
public final class DemoGlobalConfig implements IConfigModule {
    String APP_DOMAIN = "https://api.github.com/";
    //        public static String appEnv = YDLConstants.ENV_AUTO_TEST;
    public static String appEnv = YDLConstants.ENV_TEST;
//    public static String appEnv = YDLConstants.ENV_NEW_TEST;//配置未上传到maven库
//    public static String appEnv = YDLConstants.ENV_PROD;

    @Override
    public void injectAppLifecycle(@NotNull Context context, @NotNull List<IAppLifecycles> lifecycles) {
        lifecycles.add(new DemoAppLifecycles());
    }

    @Override
    public void applyOptions(@NotNull Context context, @NotNull GlobalConfig.Builder builder) {

        builder.setFrom("ydl".equals(BuildConfig.FLAVOR) ? YDLConstants.FROM_YDL : YDLConstants.FROM_XLZX)
                .addUrl("github", APP_DOMAIN)
                .setEnv(appEnv)
                .setName("yidianling")
                .setDebug(BuildConfig.DEBUG);
    }
}
