package com.ydl.confide.home.config

/**
 * @author yuanwai
 * @描述:倾诉首页配置信息
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
interface IConfideHomeConfig{
    companion object {
        /**
         * 数据类型 1.banner 2.最近倾诉 3.分类 4.为你推荐筛选模块
         *          5.为你推荐 6.听声寻人 7.最佳倾诉榜单 999.底部 更多情感恋爱专家view
         */
        const val TYPE_BANNER            = 1
        const val TYPE_RECENTLY_CONFIDED = 2
        const val TYPE_CATEGORY          = 3
        const val TYPE_RECOMMEND_FILTER  = 4
        const val TYPE_RECOMMEND         = 5
        const val TYPE_SOUND             = 6
        const val TYPE_CONSULTANT        = 7
        const val TYPE_FOOTER            = 999
        /**
         * section id. 与上面相对应
         */
        const val SECTION_BANNER            = 10001
        const val SECTION_RECENTLY_CONFIDED = 10002
        const val SECTION_CATEGORY          = 10003
        const val SECTION_RECOMMEND_FILTER  = 10004
        const val SECTION_RECOMMEND         = 10005
        const val SECTION_SOUND             = 10006
        const val SECTION_CONSULTANT        = 10007
        const val SECTION_FOOTER            = 19999


        /**
         * 筛选窗状态
         * 0.默认筛选状态 1.非默认筛选状态 2.筛选窗打开状态
         */
        const val FILTER_STATUS_NORMAL   = 0
        const val FILTER_STATUS_FILTERED = 1
        const val FILTER_STATUS_OPEN     = 2
    }
}