package com.ydl.confide.home.http


/**
 * @author yuanwai
 * @描述:倾诉首页为你推荐请求参数bean
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/11
 */
class ConfideRecommendParam private constructor(builder: Builder){
    /**
     * 页码
     */
    internal var page : Int = 1
    /**
     * 综合排序(传对应排序的ID)
     */
    private var sortType : String = ""
    /**
     * 性别(传对应性别的ID)
     */
    private var sexType : String = ""
    /**
     * 年龄(传对应年龄ID拼接成的字符串) 例如:选中60后、70后、80后,传参为:“6-7-8”
     */
    private var ageType : String = ""
    /**
     * 年龄(传对应年龄ID拼接成的字符串) 例如:选中60后、70后、80后,传参为:“6-7-8”
     */
    private var goodType : String = ""

    //当前列表已存在专家uid列表
    var notInUid : ArrayList<Int> = ArrayList()

    fun getSortType() : String{
        return sortType
    }

    fun getSexType() : String{
        return sexType
    }

    fun getAgeType() : String{
        return ageType
    }

    fun getGoodType() : String{
        return goodType
    }

    init {
        this.page = builder.page
        this.sortType = builder.sortType
        this.sexType = builder.sexType
        this.ageType = builder.ageType
        this.goodType = builder.goodType
        this.notInUid = builder.notInUid
    }

    class Builder {
        internal var page : Int = 1
        internal var sortType : String = ""
        internal var sexType : String = ""
        internal var ageType : String = ""
        internal var goodType : String = ""
        internal var notInUid : ArrayList<Int> = ArrayList()

        fun page(page: Int): Builder {
            this.page = page
            return this
        }

        fun sortType(sortType: String): Builder {
            this.sortType = sortType
            return this
        }

        fun sexType(sexType: String): Builder {
            this.sexType = sexType
            return this
        }

        fun ageType(ageType: String): Builder {
            this.ageType = ageType
            return this
        }

        fun goodType(goodType: String): Builder {
            this.goodType = goodType
            return this
        }

        fun build() : ConfideRecommendParam{
            return ConfideRecommendParam(this)
        }
    }
}


