package com.ydl.confide.home.listener

import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.home.adapter.ConfideHomeAdapter
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.widget.ConfideHomeFilterView

/**
 * @author yuanwai
 * @描述:悬浮按钮监听事件
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/25
 */
class ConfideHomeRecyleSuspendListener : RecyclerView.OnScrollListener() {

    private var mCurrentPosition = 0

    private var mSuspensionHeight: Int = RxImageTool.dip2px(48f)

    private var filterView: ConfideHomeFilterView? = null

    private var adapter: ConfideHomeAdapter? = null

    fun setFilterView(filterView: ConfideHomeFilterView) {
        this.filterView = filterView
    }

    fun setSectionAdapter(adapter: ConfideHomeAdapter) {
        this.adapter = adapter
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (null != filterView) {
            mSuspensionHeight = filterView!!.height
        }
    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
        if (null == adapter) {
            return
        }
        val manager = recyclerView!!.layoutManager as LinearLayoutManager
        if (mCurrentPosition != manager.findFirstVisibleItemPosition()) {
            mCurrentPosition = manager.findFirstVisibleItemPosition()
        }
        LogUtil.e("http----------------type="+adapter!!.getItemViewType(mCurrentPosition))
        if (adapter!!.getItemViewType(mCurrentPosition) == IConfideHomeConfig.TYPE_RECOMMEND) {
            var view = manager.findViewByPosition(mCurrentPosition + 1)
            if (view != null) {
                if (view.top <= mSuspensionHeight) {
                    filterView!!.visibility = View.VISIBLE
                } else {
//                    filterView!!.visibility = View.INVISIBLE
                }
            }
        }else if (adapter!!.getItemViewType(mCurrentPosition) == IConfideHomeConfig.TYPE_RECOMMEND || adapter!!.getItemViewType(mCurrentPosition) == IConfideHomeConfig.TYPE_SOUND){
            filterView!!.visibility = View.VISIBLE
        }else {
            filterView!!.visibility = View.INVISIBLE
        }
    }
}