package com.ydl.confide.home.popwindow.adapter

import android.content.Context
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeFiterItemBean
import com.ydl.confide.home.popwindow.ConfideHomeSortPopupWindow
import kotlinx.android.synthetic.main.confide_sort_item.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--综合排序适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class ConfideHomeSortAdapter(private val context: Context,
                             private val sortItems: ArrayList<ConfideHomeFiterItemBean>,
                             private val selectedSort: ConfideHomeFiterItemBean,
                             private val onItemSelectedListener: ConfideHomeSortPopupWindow.OnSortItemSelectedListener) : RecyclerView.Adapter<ConfideHomeSortAdapter.ViewHolder>() {

    override fun getItemCount(): Int = sortItems.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView = LayoutInflater.from(context).inflate(R.layout.confide_sort_item, parent, false)
        return ViewHolder(itemView)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val item = sortItems[position]
        holder.tvSort.text = item.name
        if (item.id == selectedSort.id) {
            holder.tvSort.setTextColor(context.resources.getColor(R.color.platform_main_theme))
        }else{
            holder.tvSort.setTextColor(ContextCompat.getColor(context, R.color._6))
        }
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val tvSort = itemView.tvSort!!

        init {
            itemView.setOnClickListener {
                if (adapterPosition != RecyclerView.NO_POSITION){
                    onItemSelectedListener.onSortItemSelected(sortItems[adapterPosition])
                }
            }
        }
    }
}