package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeRecentView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author Jim
 * @描述:最近倾诉
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10 0010
 */
class ConfideHomeRecentConfideSection(var context: Context, var confideHomeEvent: IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0) {
    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_RECENTLY_CONFIDED
    }

    private var data: ConfideHomeDataBean? = null

    fun setData(data: ConfideHomeDataBean) {
        this.data = data
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is ConsultViewHolder) {
            holder.consultView.initData(data!!)
        }
    }

    override fun getTotalDataNum(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return IConfideHomeConfig.SECTION_RECENTLY_CONFIDED
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        return ConsultViewHolder(ConfideHomeRecentView(context, confideHomeEvent))
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_RECENTLY_CONFIDED.toString())
    }


    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }

    inner class ConsultViewHolder(var consultView: ConfideHomeRecentView) : RecyclerView.ViewHolder(consultView)
}