package com.ydl.confide.home.widget

import android.content.Context
import android.os.Build
import androidx.cardview.widget.CardView
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydl_image.transform.GlideRoundTransform
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.event.IConfideHomeEvent
import kotlinx.android.synthetic.main.confide_recent_view.view.*

/**
 * @author yuanwai
 * @描述:最近倾诉View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/20
 */
class ConfideHomeRecentView(mContext: Context, private var confideHomeEvent: IConfideHomeEvent) : CardView(mContext) {

    private var dp42: Int = 0

    init {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        initLayoutParam()
        View.inflate(context, R.layout.confide_recent_view, this)

    }

    private fun initLayoutParam() {
        dp42 = RxImageTool.dip2px(42f)
        var dp15 = RxImageTool.dip2px(15f)
        var params = RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(50f))
        params.setMargins(dp15, RxImageTool.dip2px(28f), dp15, RxImageTool.dip2px(24f))
        radius = RxImageTool.dip2px(23f).toFloat()
        layoutParams = params
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            elevation = RxImageTool.dip2px(1f).toFloat()
        }
    }

    /**
     * 数据赋值
     */
    fun initData(bean: ConfideHomeDataBean?) {
        if (null == bean || null == bean.body || bean.body.isEmpty()) {
            visibility = View.GONE
            return
        }
        var bodyBean = bean.body[0]
        visibility = View.VISIBLE
        //这样处理 是防止 滑动过程中 反复去加载图片
        if (!TextUtils.isEmpty(bodyBean.confidedIcon) && img_icon.getTag(R.id.img_icon) != bodyBean.confidedIcon) {
            GlideApp.with(context)
                    .load(bodyBean.confidedIcon)
                    .override(dp42, dp42)
                    .transform(GlideRoundTransform(context, 21))
                    .into(img_icon)
            img_icon.setTag(R.id.img_icon, bodyBean.confidedIcon)
        }
        if (bodyBean.confideSex == 1) {
            img_sex.setImageResource(R.drawable.confide_new_male)
        } else {
            img_sex.setImageResource(R.drawable.confide_new_female)
        }
        tv_name.text = bodyBean.confidedName
        tv_history.text = bodyBean.confideHistory
        setOnClickListener {
            when (bodyBean.confideLine) {//1在线 2离线 3通话中
                1, 3,4 -> {
                    confideHomeEvent.latelyConfideClick(bodyBean.linkUrl)
                }
                2 -> {
                    //跳转私聊 并发送自定义消息
                    confideHomeEvent.toChatForMsg(""+bodyBean.uid)
                }
            }


        }
    }
}