package com.yidianling.consultant.http

import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.consultant.bean.ExpertSearchTopShowBean
import com.yidianling.consultant.model.SearchApi
import com.yidianling.consultant.model.bean.ExpertBannerBean
import com.yidianling.consultant.model.bean.ExpertSearchBean
import io.reactivex.Observable

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
class ExpertSearchHttpImpl : IExpertSearchHttp {

    override fun getFilterCount(params: String?): Observable<BaseAPIResponse<Int>> {
        return getSearchApi().getFilterCount(HttpConfig.JAVA_BASE_URL+ "doctor/count?"+params)
    }

    companion object {
        fun getInstance(): ExpertSearchHttpImpl {
            return Holder.INSTANCE
        }

        fun clearSearchApi() {
            Holder.INSTANCE.searchApi = null
        }
    }

    object Holder {
        val INSTANCE = ExpertSearchHttpImpl()
    }

    private var searchApi: SearchApi? = null

    private fun getSearchApi(): SearchApi {
        if (searchApi == null) {
            searchApi = YDLHttpUtils.obtainApi(SearchApi::class.java)
        }
        return searchApi!!
    }

    override fun searchDoctor(params: String?): Observable<BaseAPIResponse<ExpertSearchBean>> {
        return getSearchApi().searchDoctorService(HttpConfig.JAVA_BASE_URL+ "doctor/nlist?"+params)

    }

    override fun getBigShotData(): Observable<BaseAPIResponse<ExpertSearchTopShowBean>> {
        return getSearchApi().getBigShotData()
    }


}