package com.yidianling.consultant.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.yidianling.consultant.bean.ExpertSearchTopShowBean
import com.yidianling.consultant.model.bean.ExpertBannerBean
import com.yidianling.consultant.model.bean.ExpertSearchBean
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:专家搜索页请求接口
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
interface IExpertSearchHttp{
    /**
     * 专家搜索页请求
     */
    fun searchDoctor(params : String?): Observable<BaseAPIResponse<ExpertSearchBean>>

    /**
     * 获取当前筛选条件结果数
     */
    fun getFilterCount(params:String?): Observable<BaseAPIResponse<Int>>

    /**
     * 获取大咖专区和顶部推荐数据数据
     */
    fun getBigShotData(): Observable<BaseAPIResponse<ExpertSearchTopShowBean>>

}