package com.yidianling.consultant.modular.utils

import android.annotation.SuppressLint
import android.app.Activity
import androidx.appcompat.app.AppCompatActivity
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.ActivityManager
import com.ydl.ydlcommon.utils.ActivityManager.Companion.getInstance
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import com.yidianling.consultant.ConsultAssistantCenterActivity
import com.yidianling.consultant.ExpertSearchActivity
import com.yidianling.consultant.HotSearchActivity
import com.yidianling.consultant.constants.ConsultBIConstants
import com.yidianling.consultant.model.SearchApi
import com.yidianling.consultant.router.ConsultantIn
import com.yidianling.home.api.event.HomeModuleTabEvent
import de.greenrobot.event.EventBus
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

class ConsultAssistantEntryUtils {
    companion object {
        @SuppressLint("CheckResult")
        fun jumpConsultAssistant(activity: Activity, location: Int,ffrom2:String?) {
            ActionCountUtils.count(
                ConsultBIConstants.POSITION_DAOYI_ADVERTISEMENT_CLICK,
                "$location"
            )

            if (ConsultantIn.loginByOneKeyLogin(activity,true)) {
                // 请求接口获取咨询助理的uid
                SearchApi.getSearchApi().getConsultAssistantUidRequest(location,ffrom2)
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(Consumer {
                        /*
                        * location=1首页，3问答列表页，4我的入口，5亲子在线咨询入口，6咨询列表页导医入口，
                        * 7使用心理课进入，8使用心理课列表页进入，9测评解读页进入，10搜索页进入，11注册引导页
                        * 0小壹点击前往
                        * */
                        if (it.data==100L&&(location<=11)){
                        //跳转咨询tab栏目
                        if (location==1||location==4||location==6||location==3){
                            if (activity is ExpertSearchActivity&&!activity.isFinishing){
                                activity.finish()
                            }

                            EventBus.getDefault().post(HomeModuleTabEvent(2))
                        }else{
                            if (activity.componentName.toString().contains("CourseListContainerActivity") ){
                                getInstance()
                                    .getSecondTaskActivity()?.finish()
                                activity.finish()
                            }else{
                                if (null!=activity&&!activity.isFinishing){
                                    activity.finish()
                                }
                            }
                            EventBus.getDefault().post(HomeModuleTabEvent(2))
                        }
                        }else{
                            if (it.code == "200" && it.data != 0.toLong() && null != activity) {
                                ConsultantIn.startP2PSession(
                                    activity as AppCompatActivity,
                                    it.data.toString()
                                )
                            } else {
                                ToastUtil.toastShort("咨询助理忙碌中，请稍后再试")
                            }
                        }
                    }, object : ThrowableConsumer() {
                        override fun accept(msg: String) {
                            if (null != activity && activity is ConsultAssistantCenterActivity && !activity.isFinishing) activity.finish()
                        }
                    }
                    )
            }

        }

/*
* 根据Type0,1跳自主，2跳导医
* 在跳自主的（type=1）情况下，点击item是跳专家详情页
*
* */
        @SuppressLint("CheckResult")
        fun getTypeJump(activity: Activity, location: Int,doctorUid:Int,url:String?){
            SearchApi.getSearchApi().getJumpTypeRequest()
                .subscribeOn((Schedulers.io()))
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe (Consumer {
                    when(it.code){
                        "200"->{
                            when(it.data){
                                0->{
                                    jumpToAutoTalk(activity, doctorUid)
                                }
                                1->{
                                    if (url.isNullOrEmpty()){
                                        jumpToAutoTalk(activity, doctorUid)
                                    }else{
                                        if (url.startsWith("http")) {
                                            YDLRouterManager.router(
                                                IYDLRouterConstant.ROUTER_H5_H5,
                                                YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_URL, url), ""
                                            )
                                        } else {
                                            YDLRouterManager.router(url)
                                        }
                                    }

                                }
                                2->{
                                    jumpConsultAssistant(activity,location,null)
                                }
                                else->{
                                    jumpToAutoTalk(activity, doctorUid)
                                    LogUtil.e(it.data.toString())
                                }
                            }
                        }
                        else->{
                            ToastUtil.toastShort(it.code)
                        }
                    }
                },object:ThrowableConsumer(){
                    override fun accept(msg: String) {
                        ToastUtil.toastShort(msg)
                    }

                })
        }

        private fun jumpToAutoTalk(activity: Activity, doctorUid: Int) {
            ConsultantIn.startP2PSession(
                activity as AppCompatActivity,
                doctorUid.toString()
            )
        }
    }
}