package com.yidianling.consultant.modular.utils

import android.net.Uri
import android.text.TextUtils
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydl_router.util.YDLRouterUtils
import com.yidianling.common.tools.LogUtil
import java.io.UnsupportedEncodingException
import java.net.URLDecoder

/**
 * Created by haorui on 2019-10-13.
 * Des:
 */
object TempH5RouteUtils {

    fun tempH5Route(linkUrl: String?) {
        if (TextUtils.isEmpty(linkUrl)) {
            return
        }
        val linkUri = Uri.parse(linkUrl)
        if (linkUri != null) {
            val host = linkUri.host
            if (!TextUtils.isEmpty(host) && host == "h5") {
                //如果是h5，跳转至NewH5Activity
                try {
                    var params = URLDecoder.decode(linkUri.getQueryParameter("params"),"UTF-8")
                    ARouter.getInstance().build("/new_h5/h5").withSerializable("routerParam", params).navigation()
                    return
                }catch (e : NullPointerException){
                    LogUtil.e("params参数为空")
                }catch (e : UnsupportedEncodingException){
                    LogUtil.e("解码错误")
                }catch (e : UnsupportedOperationException){
                    LogUtil.e("这不是一个uri格式的地址")
                }
                return
            }
        }
        YDLRouterManager.router(linkUrl)
    }

    fun tempH5Route(linkUrl: String?, params: YDLRouterParams?, callBack: String?) {
        if (TextUtils.isEmpty(linkUrl)) {
            return
        }
        val newUrl = linkUrl + YDLRouterUtils.ergodic(params) + "&callback=" + callBack
        val linkUri = Uri.parse(newUrl)
        if (linkUri != null) {
            val host = linkUri.host
            if (!TextUtils.isEmpty(host) && host == "h5") {
                //如果是h5，跳转至NewH5Activity
                try {
                    var params = URLDecoder.decode(linkUri.getQueryParameter("params"),"UTF-8")
                    ARouter.getInstance().build("/new_h5/h5").withSerializable("routerParam", params).navigation()
                    return
                }catch (e : NullPointerException){
                    LogUtil.e("params参数为空")
                }catch (e : UnsupportedEncodingException){
                    LogUtil.e("解码错误")
                }catch (e : UnsupportedOperationException){
                    LogUtil.e("这不是一个uri格式的地址")
                }
                return
            }
        }
        YDLRouterManager.router(linkUrl, params)
    }
}
