package com.yidianling.consultant.router

import android.app.Activity
import android.content.Context
import androidx.appcompat.app.AppCompatActivity
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.im.api.service.IImService
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/23
 */
object ConsultantIn {

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }
    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    // 打开小壹聊天界面
    fun startP2PXiaoYi(context: Context) {
        getImService().startP2PXiaoYi(context)
    }

    fun isLogin(): Boolean {
        return ModularServiceManager.provide(IUserService::class.java).isLogin()
    }

    fun startP2PSession(context: Activity, toUid: String) {
        getImService().startP2PSession(context, toUid)
    }

    fun mainIntent(activity: Activity){
        getAppService().mainIntent(activity)
    }

    fun getUserImpl(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun toLogin(activity: Activity) {
        activity.startActivity(ModularServiceManager.provide(IUserService::class.java).loginWayIntent(activity))
    }

    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean{
        return getUserService().loginByOneKeyLogin(context,isOpenDialog)
    }
}