package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.LinearSnapHelper
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.RegionRecyclerViewAdapter
import com.yidianling.consultant.adapter.SubRecyclerViewAdapter
import com.yidianling.consultant.model.bean.RegionItem
import com.yidianling.consultant.model.bean.SubItem
import kotlinx.android.synthetic.main.consultant_ui_region_popup_window.view.*

/**
 * 地区选择弹窗
 */
class AreaPopupWindow(val context: Context, regionList: ArrayList<RegionItem>,
                      private var selectedRegion: RegionItem, private var selectedSub: SubItem)
    : PopupWindow(null, ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dp2px(369f)) {

    private val subList = ArrayList<SubItem>()
    private val regionAdapter = RegionRecyclerViewAdapter(context, regionList, selectedRegion)
    private val subAdapter = SubRecyclerViewAdapter(context, subList, selectedSub)

    var onRegionSelectedListener: OnRegionSelectedListener? = null

    init {
        subList.addAll(selectedRegion.sub)
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_ui_region_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        this.height = ((RxDeviceTool.getScreenHeight(context) - RxImageTool.dp2px(90f)) * 0.618).toInt() //设置高度为屏幕的80%

        view.rvRegion.layoutManager =
            LinearLayoutManager(
                context,
                LinearLayoutManager.VERTICAL,
                false
            )
        regionAdapter.onItemClickListener = MyBaseAdapter.OnItemClickListener { _, _, data ->
            selectedRegion = data
            subList.clear()
            subList.addAll(data.sub)
            subAdapter.notifyDataSetChanged()
            view.rvSub.scrollToPosition(0)
        }
        view.rvRegion.adapter = regionAdapter
//        view.rvRegion.addItemDecoration(DividerItemDecoration(context, LinearLayoutManager.VERTICAL))
        val helper = LinearSnapHelper()
//        LinearSnapHelper().attachToRecyclerView(view.rvRegion)
        val i = regionList
                .takeWhile { it.key != selectedRegion.key }
                .count()
        view.rvRegion.scrollToPosition(i + 1)


        view.rvSub.layoutManager =
            LinearLayoutManager(
                context,
                LinearLayoutManager.VERTICAL,
                false
            )
        subAdapter.onItemClickListener = MyBaseAdapter.OnItemClickListener { _, _, data ->
            selectedSub = data
            onRegionSelectedListener?.onRegionSelected(selectedRegion, selectedSub)
        }
        view.rvSub.adapter = subAdapter
//        view.rvSub.addItemDecoration(DividerItemDecoration(context, LinearLayoutManager.VERTICAL))
//        LinearSnapHelper().attachToRecyclerView(view.rvSub)
        view.rvSub.scrollToPosition(subList.indexOf(selectedSub) + 1)
    }

    interface OnRegionSelectedListener {
        fun onRegionSelected(region: RegionItem, sub: SubItem)
    }
}
