package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.ydl.ydlcommon.view.SpaceItemDecorator2
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.CategoryRecyclerViewAdapter
import com.yidianling.consultant.listener.OnCategoriesSelectedListener
import com.yidianling.consultant.model.bean.CateItem
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.*

/**
 * 主题弹窗
 * Created by zqk on 17-9-15.
 */
class CategoryPopupWindow(context: Context, categories: ArrayList<CateItem>, selectedCategories: ArrayList<CateItem>)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {
    var onSubjectsSelectedListener: OnCategoriesSelectedListener? = null

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_ui_subject_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvSubject = view.rvSubject
        val adapter = CategoryRecyclerViewAdapter(context, categories, selectedCategories)
        rvSubject.adapter = adapter
        rvSubject.layoutManager = GridLayoutManager(
            context,
            3,
            LinearLayoutManager.VERTICAL,
            false
        )
        rvSubject.addItemDecoration(SpaceItemDecorator2(RxImageTool.dp2px(5f), 3))
        inputMethodMode = PopupWindow.INPUT_METHOD_NEEDED
        view.btnConfirm.setOnClickListener {
            onSubjectsSelectedListener?.onCategoriesSelected(selectedCategories)
            dismiss()
        }
    }
}