package com.yidianling.consultant.ui.view.topView

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.consultant.R
import com.yidianling.consultant.bean.ExpertSearchBigShotBean
import kotlinx.android.synthetic.main.consultant_expert_search_big_shot_three.view.*

class BigShotThreeView : LinearLayout {


    constructor(context: Context) : super(context) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {
        layoutParams = LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )

        orientation = HORIZONTAL
        View.inflate(mContext, R.layout.consultant_expert_search_big_shot_three, this)
    }

    fun setUrl(
        bean1: ExpertSearchBigShotBean,
        bean2: ExpertSearchBigShotBean,
        bean3: ExpertSearchBigShotBean
    ) {
        GlideApp.with(mContext).load(bean1.topicImages[2].imageUrl).into(consultant_three_img_1)
        consultant_three_img_1.setOnClickListener {
            val h5Params = H5Params(bean1.specialTopicUrl, null)
            NewH5Activity.start(context, h5Params)
        }
        GlideApp.with(mContext).load(bean2.topicImages[2].imageUrl).into(consultant_three_img_2)
        consultant_three_img_2.setOnClickListener {
            val h5Params = H5Params(bean2.specialTopicUrl, null)
            NewH5Activity.start(context, h5Params)
        }
        GlideApp.with(mContext).load(bean3.topicImages[2].imageUrl).into(consultant_three_img_3)
        consultant_three_img_3.setOnClickListener {
            val h5Params = H5Params(bean3.specialTopicUrl, null)
            NewH5Activity.start(context, h5Params)
        }

    }
}