package com.yidianling.consultant.api

import android.app.Activity
import android.content.Context
import androidx.fragment.app.Fragment
import com.alibaba.android.arouter.facade.template.IProvider
import com.yidianling.consultant.bean.GuideBean
import com.yidianling.consultant.bean.Keyworks

/**
 * Created by xj on 2019/11/14.
 */
interface IConsultantService: IProvider {
    // 显示咨询助理弹框
    fun showConsultAssistantDialog(activity: Activity)
    // 隐藏咨询助理弹框
    fun hideConsultAssistantDialog()

    // 显示咨询助理弹框
    fun showConsultAssistantMineDialog(activity: Activity)
    // 隐藏咨询助理弹框
    fun hideConsultAssistantMineDialog()

    fun resetConsultAssistantDialogStatus()

    fun expertSearchIntent(activity: android.app.Activity, category: String, showType: Int, isInitShowHot: kotlin.Boolean): android.content.Intent

    fun startExpertSearchActivity(context: Context, category: String, categoryName: String, showType: Int)

    fun startExpertSearchActivity(mContext: Context, category: String)

    fun getHotSearch(): kotlin.collections.MutableList<Keyworks>

    fun setHotSearch(hotSearch: kotlin.collections.MutableList<Keyworks>): kotlin.Unit

    fun getExpertSearchFragment(): Fragment

    fun getGuideImage(source:Int):List<GuideBean>?

    fun requestGuideData()

    fun jumpConsultAssistant(activity: Activity, location:Int)

    //根据返回Type跳转自主或者导医
    fun dueToTypeJumpAutoOrGuide(activity: Activity, location:Int,doctorId:Int,url:String)

    // 咨询列表页显示咨询助理弹框
    fun showConfideListDialog(activity: Activity)
}