package com.yidianling.course.courseNew

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import androidx.recyclerview.widget.LinearLayoutManager
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.actions.share.ShareUtils
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.data.http.RxUtils
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxNetTool
import com.yidianling.course.R
import com.yidianling.course.bean.Course
import com.yidianling.course.model.TopicCourseBean
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.activity_course_topic.*
import kotlinx.android.synthetic.main.course_layout_title_bar.*

/**
 * 课程专题页面
 */
@Route(path = "/course/special")
class CourseTopicActivity : BaseActivity(), View.OnClickListener, SwipeRefreshLayout.OnRefreshListener {

    private var opicCourseBean: TopicCourseBean? = null
    private var adapter: CourseTopicAdapter? = null
    private var datas: List<Course>? = null
    private var specialId: Int? = 0
    private var headView: ImageView? = null
    private var footerView: View? = null

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = true)
    }
    companion object {
        fun start(context: Context, id: String) {
            val i = Intent(context, CourseTopicActivity::class.java)
            i.putExtra("special_id", id)
            context.startActivity(i)
        }
    }

    override fun layoutResId(): Int {
        return R.layout.activity_course_topic
    }

    override fun initDataAndEvent() {
        tv_title.text = "课程专题"
        iv_back.setOnClickListener(this)
        course_topic_rcv.layoutManager =
            LinearLayoutManager(this)
        datas = ArrayList()
        adapter = CourseTopicAdapter(this, datas!!)
        course_topic_rcv.adapter = adapter
        if (!TextUtils.isEmpty(intent.getStringExtra("special_id"))) {
            specialId = intent.getStringExtra("special_id").toInt()
        }
        LogUtil.i("special id: $specialId")
        swl.setColorSchemeResources(R.color.platform_main_theme)
        swl.setOnRefreshListener(this)
        tv_left_menu.setOnClickListener {
            //分享
            share()
        }
        initHeadView()
        initFooterView()
        loadData()
    }

    override fun onRefresh() {
        swl.isRefreshing = true
        loadData()
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.iv_back -> finish()
        }
    }

    fun initHeadView() {
        headView = LayoutInflater.from(this).inflate(R.layout.item_course_topic_image, course_topic_rcv, false) as ImageView
        adapter?.addHeaderView(headView)
    }

    fun initFooterView() {
        footerView = LayoutInflater.from(this).inflate(R.layout.item_course_topic_text, course_topic_rcv, false)
        adapter?.addFooterView(footerView)
    }

    private fun share() {
        if (null != opicCourseBean && null != opicCourseBean!!.share) {
            ShareUtils.share(CourseTopicActivity@ this, opicCourseBean!!.share!!.title, opicCourseBean!!.share!!.share_url, opicCourseBean!!.share!!.desc, opicCourseBean!!.share!!.cover)
        }
    }

    @SuppressLint("CheckResult")
    private fun loadData() {
        if (!RxNetTool.isConnected(CourseTopicActivity@ this)) {
            swl.isRefreshing = false
            course_topic_rcv.visibility = View.GONE
            v_no_network.visibility = View.VISIBLE
            return
        }
        course_topic_rcv.visibility = View.VISIBLE
        v_no_network.visibility = View.GONE
        CourseRetrofitUtils.getCourseTopic(specialId.toString())
                .subscribeOn(Schedulers.io())
                .compose(RxUtils.resultJavaData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    LogUtil.i("resp: $resp")
                    opicCourseBean = resp
                    course_topic_rcv.visibility = View.VISIBLE
                    adapter?.setDatas(resp.courses)
                    GlideApp.with(CourseTopicActivity@ this).load(resp.pic).into(headView)
                    if (resp.explain.isNullOrEmpty()) {
                        footerView?.findViewById<LinearLayout>(R.id.ll_title)!!.visibility = View.GONE
                    } else {
                        footerView?.findViewById<LinearLayout>(R.id.ll_title)!!.visibility = View.VISIBLE
                        footerView?.findViewById<TextView>(R.id.tv_content)!!.text = resp.explain!!
                    }
                    adapter?.notifyDataSetChanged()
                    swl.isRefreshing = false
                }, { throwable ->
                    LogUtil.e(throwable.toString())
                    course_topic_rcv.visibility = View.GONE
                    swl.isRefreshing = false
                })

    }


}
