package com.yidianling.course.courseNew.courseList.widget

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.BitmapDrawable
import androidx.core.content.ContextCompat
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import android.widget.TextView
import com.yidianling.course.R
import kotlinx.android.synthetic.main.course_sort_popup_window.view.*

/**
 * @author yuanwai
 * @描述:课程综合排序popupWindow(选项是本地写死的，选择后传给服务端的也是固定字段)
 * 选项对应接口字段：synthesize综合 read人气 price价格 new最新
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class CourseSortPopupWindow(val context: Context, var selectedSort: String, private val onSortItemSelectedListener: OnSortItemSelectedListener)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.course_sort_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        view.v_zhezhao.setOnClickListener {
            dismiss()
        }
        when (selectedSort) {//ynthesize综合 read人气 price价格 new最新
            "synthesize" -> {
                setSelect(view.tv_ynthesize)
            }
            "read" -> {
                setSelect(view.tv_read)
            }
            "price" -> {
                setSelect(view.tv_price)
            }
            "new" -> {
                setSelect(view.tv_new)
            }
        }

        view.tv_ynthesize.setOnClickListener {
            onSortItemSelectedListener.onSortItemSelected("synthesize")
            dismiss()
        }
        view.tv_read.setOnClickListener {
            onSortItemSelectedListener.onSortItemSelected("read")
            dismiss()
        }
        view.tv_price.setOnClickListener {
            onSortItemSelectedListener.onSortItemSelected("price")
            dismiss()
        }
        view.tv_new.setOnClickListener {
            onSortItemSelectedListener.onSortItemSelected("new")
            dismiss()
        }
    }

    private fun setSelect(textView: TextView) {
        textView.setTextColor(ContextCompat.getColor(context, R.color.platform_main_theme))
        textView.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
    }


    interface OnSortItemSelectedListener {
        fun onSortItemSelected(sortItem: String)
    }
}