package com.yidianling.course.courseNew.mine;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import com.google.android.material.tabs.TabLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.utils.DisplayUtils;
import com.yidianling.course.CourseListFragment;
import com.yidianling.course.R;
import com.yidianling.course.widget.CourseRedPacketView;
import com.yidianling.course.widget.SearchBarView;

import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Field;

/**
 * Created by Jim on 2018/7/16 0016.
 * 心理课程
 */

public class MyCourseActivity extends BaseActivity {

    public final static String TAB_KEY = "tab_index";
    public final static int TAB_PAIED = 2;
    public final static int TAB_COLLECT = 1;

    private int tabIndex;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    public static void start(Context context) {
        Intent i = new Intent(context, MyCourseActivity.class);
        i.putExtra(TAB_KEY, TAB_PAIED);
        context.startActivity(i);
    }

    public static void start(Context context, int index) {
        Intent i = new Intent(context, MyCourseActivity.class);
        i.putExtra(TAB_KEY, index);
        context.startActivity(i);
    }

    @Override
    protected int layoutResId() {
        return R.layout.activity_my_course;
    }

    @Override
    protected void initDataAndEvent() {
        tabIndex = getIntent().getIntExtra(TAB_KEY, -1);
        TextView tv = findViewById(R.id.tv_title);
        tv.setText("我的课程");
        ImageView iv = findViewById(R.id.iv_back);
        findViewById(R.id.tv_left_menu).setVisibility(View.GONE);
        iv.setOnClickListener(view -> {
            finish();
        });
        SearchBarView searchBarView = findViewById(R.id.search_bar);
        searchBarView.initBarType(SearchBarView.JUMP_TO_SEARCH_COURSE, null);
        TabLayout tabLayout = findViewById(R.id.my_courses_tabs);
        ViewPager viewPager = findViewById(R.id.my_course_vp);
        tabLayout.setupWithViewPager(viewPager);
        viewPager.setAdapter(new MyCourseFragmentAdapter(getSupportFragmentManager()));
        viewPager.setCurrentItem(2);
        tabLayout.post(new Runnable() {
            @Override
            public void run() {
                setIndicator(tabLayout, 15, 15);
            }
        });

        //初始化倾诉红包
        initConfideRedPacketView();
    }

    private void initConfideRedPacketView() {
        CourseRedPacketView courseRedPacketView = findViewById(R.id.courseRedPacketView);
        courseRedPacketView.initData(View.VISIBLE);
        courseRedPacketView.setConfide();
    }


    public void setIndicator(TabLayout tabs, int leftDip, int rightDip) {
        Class<?> tabLayout = tabs.getClass();
        Field tabStrip = null;
        try {
            tabStrip = tabLayout.getDeclaredField("mTabStrip");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }

        tabStrip.setAccessible(true);
        LinearLayout llTab = null;
        try {
            llTab = (LinearLayout) tabStrip.get(tabs);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }

        int left = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, leftDip, Resources.getSystem().getDisplayMetrics());
        int right = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, rightDip, Resources.getSystem().getDisplayMetrics());

        for (int i = 0; i < llTab.getChildCount(); i++) {
            View child = llTab.getChildAt(i);
            child.setPadding(0, 0, 0, 0);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.MATCH_PARENT, 1);
            params.leftMargin = DisplayUtils.dip2px(this, left);
            params.rightMargin = DisplayUtils.dip2px(this, right);
            child.setLayoutParams(params);
            child.invalidate();
        }
    }

    static class MyCourseFragmentAdapter extends FragmentPagerAdapter {

        private Fragment[] mFragments;
        private String[] titles = new String[]{"收藏", "已购"};

        public MyCourseFragmentAdapter(FragmentManager fm) {
            super(fm);
            mFragments = new Fragment[]{CourseListFragment.newInstance(2), CourseListFragment.newInstance(1)};
        }

        @Override
        public Fragment getItem(int position) {
            if (position == 0) {
            } else {
            }

            return mFragments[position];
        }

        @Override
        public int getCount() {
            return mFragments.length;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            return titles[position];
        }
    }
}
