package com.yidianling.course.coursePlay

import android.annotation.SuppressLint
import android.text.TextUtils
import android.view.ViewGroup
import android.widget.RelativeLayout
import com.ydl.media.audio.AudioPlayer
import com.ydl.media.audio.model.Music
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxNetTool
import com.yidianling.course.bean.CourseExtraBean
import com.yidianling.course.bean.CourseMediaBean
import com.yidianling.course.listener.HPlayStatusListener
import com.yidianling.course.widget.HPlayView


/**
 * 课程播放器的item
 * Created by harvie on 2017/6/26 0026.
 */
class CoursePlayItemViewAudio : RelativeLayout, PlayViewInterface {
    var activity: CoursePlayActivity? = null
    private var courseExtra: CourseExtraBean? = null
    var playView: HPlayView? = null
    //播放列表
    var playList: ArrayList<CourseMediaBean> = ArrayList()

    var hasEnsureNetStatus = false
    var currentIndex = 0

    companion object {
        fun create(activity: CoursePlayActivity, playType: Int): PlayViewInterface {
            return CoursePlayItemViewAudio(activity)
        }
    }

    @SuppressLint("InvalidWakeLockTag")
    private constructor(context: CoursePlayActivity) : super(context) {
        playView = HPlayView(context)
        var width = RxDeviceTool.getScreenWidth(context)
        var heigth = width * 9 / 16
        var layoutP = ViewGroup.LayoutParams(LayoutParams.MATCH_PARENT, heigth)
        playView?.layoutParams = layoutP
        this.addView(playView)
        activity = context
        initView()

    }

    fun initView() {
        setListener()
    }

    override fun onResume() {

    }

    override fun onPause() {

    }

    override fun onNewIntent() {
    }

    //设置监听事件
    fun setListener() {
        playView?.listener = object : HPlayStatusListener {
            override fun isCanPlay(data: Music?): Boolean {
                var canPlay = false
                //非试听
                if (courseExtra!!.isBuy) {
                    //已购买
                    canPlay = true
                } else {
                    //未购买，判断是否是试听课程
                    //即未购买，也不是试听，弹窗提示
                    if (activity == null) return false
                    CommonDialog(activity)
                        .setMessage("\n购买课程，获取完整课程内容\n")
                        .setLeftOnclick("放弃") {

                        }
                        .setRightClick("购买") {
                            //跳转支付页
                            activity?.addCourseOrder()
                        }
                        .setCancelAble(false)
                        .show()
                }
                return canPlay
            }

            override fun onPrepared(data: Music?, index: Int) {
                //更新播放列表的状态
                activity!!.updatePlayingListStatus(index)
            }

        }
    }

    /**
     * 设置显示数据
     */
    override fun setData(
        index: Int,
        list: ArrayList<CourseMediaBean>,
        courseExtra: CourseExtraBean,
        from: Int,
        isAutoPlay: Boolean
    ) {

        if (list.isEmpty()) return
        playList.clear()
        playList.addAll(list)
        this.courseExtra = courseExtra
        currentIndex = index

        if (courseExtra.isBuy) {
            playView?.setAutoNext(true)
        } else {
            //未购买，取消自动播放
            playView?.setAutoNext(false)
        }
        playView?.setImageBackground(courseExtra.pic)

        playView!!.setData(stringToMusicPlayerList(playList))


        if (AudioPlayer.get().isPlaying) {
            hasEnsureNetStatus = true
        }

        if (RxNetTool.isWifi(activity!!)) {
            if (AudioPlayer.get().isPlaying && (from == 1 || from == 2)) {
                if (TextUtils.equals(playView?.getCurrentUrl(), list[currentIndex].url)) {
                    playView?.updateView(currentIndex)
                } else {
                    if (isAutoPlay){
                        playView?.play(currentIndex)
                    }
                }
            } else {
                if (isAutoPlay){
                    playView?.play(currentIndex)
                }
            }
        } else {
            if (hasEnsureNetStatus) {
                if (AudioPlayer.get().isPlaying && (from == 1 || from == 2)) {
                    if (TextUtils.equals(playView?.getCurrentUrl(), list[currentIndex].url)) {
                        playView?.updateView(currentIndex)
                    } else {
                        if (isAutoPlay){
                            playView?.play(currentIndex)
                        }
                    }
                } else {
                    if (isAutoPlay){
                        playView?.play(currentIndex)
                    }
                }
            } else {
                playView?.showNetNotice {
                    hasEnsureNetStatus = true
                    if (AudioPlayer.get().isPlaying && (from == 1 || from == 2)) {
                        if (TextUtils.equals(playView?.getCurrentUrl(), list[currentIndex].url)) {
                            playView?.updateView(currentIndex)
                        } else {
                            if (isAutoPlay){
                                playView?.play(currentIndex)
                            }
                        }
                    } else {
                        if (isAutoPlay){
                            playView?.play(currentIndex)
                        }
                    }
                }
            }
        }
    }

    //将列表转为播放器可用列表
    private fun stringToMusicPlayerList(list: List<CourseMediaBean>): ArrayList<Music> {
        var nlist = ArrayList<Music>()
        try {
            for (i in list.indices) {
                var be = Music()
                be.path = list[i].url
                be.coverPath = courseExtra!!.pic
                be.title = list[i].title
                be.artist = list[i].doctorName
                nlist.add(be)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return nlist
    }

    override fun onDestroy() {
        playView?.onDestroy()
        playView = null
    }
}