package com.yidianling.course.coursePlay

import android.annotation.SuppressLint
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.adapter.CommonRecyclerAdapter
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.view.BaseViewHolder
import com.ydl.ydlcommon.view.CircleImageView
import com.ydl.ydlcommon.view.FootViewLoadMore
import com.ydl.ydlcommon.view.TitleBar
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import com.yidianling.course.R
import com.yidianling.course.bean.CoursePlayBean
import com.yidianling.course.net.Command
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * 课程课后笔记列表
 *
 */
class CourseReplyListActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.activity_course_reply_list
    }

    override fun initDataAndEvent() {
        course_id = intent.getIntExtra("course_id", 0)

        initView()

        getListData(false)
    }

    var title_bar: TitleBar? = null

    var recycler_list: RecyclerView? = null

    var footView: FootViewLoadMore? = null

    var adapter: CommonRecyclerAdapter<CoursePlayBean.Comments>? = null

    var page = 1 //分页

    //课程id
    var course_id = 0

    fun initView() {
        title_bar = findViewById<TitleBar>(R.id.title_bar)
        recycler_list = findViewById<RecyclerView>(R.id.recycler_list)
        recycler_list?.layoutManager =
            LinearLayoutManager(
                mContext,
                LinearLayoutManager.VERTICAL,
                false
            )

        adapter = CommonRecyclerAdapter<CoursePlayBean.Comments>(recycler_list, R.layout.item_course_play_recylist)
                .setBindDataCallback(object : CommonRecyclerAdapter.BindDataCallback<CoursePlayBean.Comments> {
                    override fun bindDatabindData(holder: BaseViewHolder, t: CoursePlayBean.Comments, position: Int) {
                        //绑定数据
                        var img: CircleImageView = holder.getView(R.id.img_head)
                        GlideApp.with(applicationContext).load(t.head).into(img)

                        holder.setText(R.id.text_name, t.name)
                        holder.setText(R.id.text_time, t.create_time)
                        holder.setText(R.id.text_des, t.content)
                    }
                })
                .setOnLoadMoreListener(object : CommonRecyclerAdapter.OnLoadMoreLIstener {
                    override fun onLoadMore() {
                        getListData(true)
                        LogUtil.e("---------------------------------------")
                    }
                })
        footView = FootViewLoadMore(mContext)
        adapter?.addFootView(footView)
        recycler_list?.adapter = adapter
    }

    //获取列表数据
    @SuppressLint("CheckResult")
    fun getListData(isLoadMore: Boolean) {
        if (isLoadMore) {
            page++
        } else {
            page = 1
        }
        if (isLoadMore) {
            footView?.onLoading()
        } else {
            showProgressDialog(null)
        }


        val cmd = Command.CourseReplyList(course_id, page)
        CourseRetrofitUtils.courseReplyList(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    if (!isLoadMore) {
                        dismissProgressDialog()
                    }

                    if (resp.code == 0) {
                        //跟新view显示
                        updateView(isLoadMore, resp.data as List<CoursePlayBean.Comments>)
                    } else {
                        footView?.onError()
                        ToastUtil.toastShort(resp.msg)
                    }
                }, {
                    throwable->
                    footView?.onError()
                    if (!isLoadMore) {
                        dismissProgressDialog()
                    }
                    CourseRetrofitUtils.handleError(mContext, throwable)
                })
    }

    //跟新视图
    fun updateView(isLoadMore: Boolean, list: List<CoursePlayBean.Comments>) {
        if (list == null) return
        if (list.size == 0) {
            footView?.onFinish()
            return
        }
        if (isLoadMore) {
            adapter?.addDatas(list)
        } else {
            adapter?.update(list)
        }
    }
}
