package com.yidianling.course.coursePlay.presenter

import android.annotation.SuppressLint
import com.yidianling.common.tools.ToastUtil
import com.yidianling.course.bean.CourseMediaDetailBean
import com.yidianling.course.coursePlay.CoursePlayActivity
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * 课程播放页--数据传输与逻辑处理层
 * Created by harvie on 2017/6/28 0028.
 */
class CoursePlayPresenter(val view: CoursePlayActivity) {
    @SuppressLint("CheckResult")
    fun getInitData(course_id: Int) {
        view.showLoadingDialog()
        CourseRetrofitUtils.getCoursePlayData(course_id.toString())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    view.dismissLoadingDialog()
                    if (resp.code == 200) {
                        //跟新view显示
                        if (resp.data != null && resp.data is CourseMediaDetailBean) {
                            view.updateView(resp.data as CourseMediaDetailBean)
                        } else {
                            ToastUtil.toastShort("解析出错")
                        }
                    } else {
                        ToastUtil.toastShort(resp.msg)
                    }
                }, { t ->
                    view.dismissLoadingDialog()
                    CourseRetrofitUtils.handleError(view, t)
                })
    }

}