package com.yidianling.course.course_special_list.adapter

import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.yidianling.course.course_special_list.widget.CourseSpecialListItemView
import com.yidianling.course.course_special_list.bean.CourseSpecialItemBean
import com.yidianling.course.course_special_list.event.ICourseSpecialListEvent
import java.util.*

/**
 * @author yuanwai
 * @描述:课程专题列表适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/18
 */
class CourseSpecialListAdapter(private var mListData: List<CourseSpecialItemBean>,
                               private var courseSpecialListEvent: ICourseSpecialListEvent) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {


    fun updataItems(list: List<CourseSpecialItemBean>) {
        if (null == mListData || mListData.isEmpty()) {
            mListData = ArrayList()
        } else {
            (mListData as ArrayList).clear()
        }
        (mListData as ArrayList).addAll(list)
    }

    fun addItems(list: List<CourseSpecialItemBean>) {
        if (null == mListData || mListData.isEmpty()) {
            mListData = ArrayList()
        }
        (mListData as ArrayList).addAll(list)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return CourseSpecialItemViewHolder(CourseSpecialListItemView(parent.context, courseSpecialListEvent))
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) =
            if (holder is CourseSpecialItemViewHolder && null != holder.courseSpecialItemView) {
                holder.courseSpecialItemView!!.initData(mListData[position])
            } else {

            }

    override fun getItemCount(): Int {
        return mListData.size
    }

    /**
     * 课程专题列表viewHolder
     */
    inner class CourseSpecialItemViewHolder(itemView: CourseSpecialListItemView) : RecyclerView.ViewHolder(itemView) {
        var courseSpecialItemView: CourseSpecialListItemView? = null

        init {
            courseSpecialItemView = itemView
        }
    }
}