package com.yidianling.course.course_special_list.widget

import android.annotation.SuppressLint
import android.content.Context
import androidx.constraintlayout.widget.ConstraintLayout
import android.text.TextUtils
import android.view.View
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.course.R
import com.yidianling.course.course_special_list.bean.CourseSpecialItemBean
import com.yidianling.course.course_special_list.event.ICourseSpecialListEvent
import kotlinx.android.synthetic.main.course_special_item_view.view.*

/**
 * @author yuanwai
 * @描述:课程专题列表 Item View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/18
 */
class CourseSpecialListItemView(
    private var mContext: Context,
    private var courseSpecialListEvent: ICourseSpecialListEvent
) : ConstraintLayout(mContext) {

    private var cacheBean: CourseSpecialItemBean? = null

    init {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.course_special_item_view, this)
        setOnClickListener {
            if (null != cacheBean) {
                courseSpecialListEvent.toCourseSpecial(cacheBean!!.id)
            }
        }
    }

    /**
     * 数据赋值
     */
    @SuppressLint("SetTextI18n")
    fun initData(bean: CourseSpecialItemBean?) {
        cacheBean = bean
        if (null == bean) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        //专题图片
        if (!TextUtils.isEmpty(bean.pic)) {
            GlideApp.with(context).load(bean.pic).dontAnimate().into(iv_head)
        }
        //专题名称
        tv_title.text = bean.name
        tv_courseNumContent.text = "共" + bean.totalValidCourse + "节课程"
    }
}