package com.yidianling.course.lifeCallback

import android.app.Activity
import android.app.Application
import android.os.Bundle
import android.text.TextUtils
import com.ydl.media.audio.AudioPlayer
import com.ydl.media.view.PlayTypeEnum
import com.ydl.media.view.PlayerFloatHelper

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/11/19
 */

class CoursePlayLifecycle : Application.ActivityLifecycleCallbacks {
    override fun onActivityPaused(activity: Activity?) {
    }

    override fun onActivityResumed(activity: Activity?) {
        if (!PlayerFloatHelper.isCanClick) {
            PlayerFloatHelper.hide()
            PlayerFloatHelper.removeView(activity!!)
            AudioPlayer.get().stopPlayer()
        } else {
            PlayerFloatHelper.showIfPlaying(activity!!)
            if (!TextUtils.isEmpty(PlayerFloatHelper.playTempData["course_id"])) {
                PlayerFloatHelper.playingType = PlayTypeEnum.PLAY_TYPE_COURSE
            }
            if (!TextUtils.isEmpty(PlayerFloatHelper.playTempData["fmId"])) {
                PlayerFloatHelper.playingType = PlayTypeEnum.PLAY_TYPE_FM
            }
        }
    }

    override fun onActivityStarted(activity: Activity?) {
    }

    override fun onActivityDestroyed(activity: Activity?) {
    }

    override fun onActivitySaveInstanceState(activity: Activity?, outState: Bundle?) {
    }

    override fun onActivityStopped(activity: Activity?) {
    }

    override fun onActivityCreated(activity: Activity?, savedInstanceState: Bundle?) {
    }
}