package com.yidianling.dynamic;

import android.os.Bundle;
import androidx.fragment.app.Fragment;

import com.ydl.ydlcommon.ui.LoadingDialogFragment;


/**
 * Created by xiongyu on 2017/3/13.
 */
public class DynamicFragment extends Fragment {
    boolean isonActivityCreated;

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        isonActivityCreated=true;
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            onPause();
        }else{
            onResume();
        }
    }


    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser) {
            //相当于Fragment的onResume
            if(isonActivityCreated){
                onResume();
            }
        } else {
            //相当于Fragment的onPause
            if(isonActivityCreated){
                onPause();
            }
        }
    }


    protected LoadingDialogFragment loadingDialogFragment;

    public void showProgressDialog(String msg){
        if (loadingDialogFragment == null){
            loadingDialogFragment = LoadingDialogFragment.Companion.newInstance(msg);
        }
        loadingDialogFragment.show(getChildFragmentManager(), null);
    }

    public void dismissProgressDialog(){
        if (loadingDialogFragment != null && loadingDialogFragment.isAdded()){
            loadingDialogFragment.dismissAllowingStateLoss();
            loadingDialogFragment = null;
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        dismissProgressDialog();
    }
}
