package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.RecommendTopic;

import java.util.List;

/**
 * Created by xiongyu on 2017/3/14.
 */

public class SelectTopicAdapter extends RecyclerView.Adapter<SelectTopiViewHolder> {
    protected Context mContext;
    protected List<RecommendTopic> mDatas;
    protected LayoutInflater mInflater;
    public interface OnItemClickLister {
        void onItemClick(View view, int position);

        void onItemLongClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public SelectTopicAdapter(List<RecommendTopic> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public SelectTopiViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= mInflater.inflate(R.layout.dynamic_item_select_topic,parent,false);
        SelectTopiViewHolder viewHolder= new SelectTopiViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(SelectTopiViewHolder holder, int position) {
        RecommendTopic Topic=mDatas.get(position);
        String topic_title=Topic.getTopic_title();
        holder.topic_title_tv.setText(topic_title);
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }
    /**
     * 添加股据到指定位置
     * @param pos 数据添加的位置
     * @param obj 数据
     */
    public  void addData(int pos,RecommendTopic obj){
        mDatas.add(obj);
        notifyItemInserted(pos);
    }

    /**
     * 删除股票到指定位置
     * @param pos
     */
    public void deleteData(int pos){
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }

    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final SelectTopiViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemLongClick(holder.itemView,layoutPosition);
                    return false;
                }
            });
        }
    }
}

class SelectTopiViewHolder extends RecyclerView.ViewHolder{
    TextView topic_title_tv;
    public SelectTopiViewHolder(View itemView) {
        super(itemView);
        topic_title_tv=(TextView)itemView.findViewById(R.id.item_select_topic_title_tv);
    }
}