package com.yidianling.dynamic.publishTrend;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.view.widgets.RecyclerViewForScrollView;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.adapter.SelectTopicAdapter;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.common.view.FullyLinearLayoutManager;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.model.RecommendTopic;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;


/**
 * 选择话题
 */
public class SelecTopicActivity extends BaseActivity {

    private TextView Cancletv;
    private RecyclerViewForScrollView focus_rcv, recommend_rcv;
    private List<RecommendTopic> mDatasR, mDatasF;
    SelectTopicAdapter adapterR, adapterF;
    RelativeLayout select_topic_focus_hint_rel, select_topic_recommend_hint_rel;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dynamic_activity_selec_topic);
        Cancletv = (TextView) findViewById(R.id.select_topic_cancel_tv);
        focus_rcv = (RecyclerViewForScrollView) findViewById(R.id.select_topic_focus_rcv);
        recommend_rcv = (RecyclerViewForScrollView) findViewById(R.id.select_topic_recommend_rcv);
        select_topic_focus_hint_rel = (RelativeLayout) findViewById(R.id.select_topic_focus_hint_rel);
        select_topic_recommend_hint_rel = (RelativeLayout) findViewById(R.id.select_topic_recommend_hint_rel);
        mDatasR = new ArrayList<RecommendTopic>();
        mDatasF = new ArrayList<RecommendTopic>();
        Cancletv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setClass(SelecTopicActivity.this, PublishTrendActivity.class);
                Bundle bundle = new Bundle();
                bundle.putString("type", "back");
                intent.putExtra("bundle", bundle);
                setResult(RESULT_OK, intent);
                finish();
            }
        });

        if (adapterR == null) {
            adapterR = new SelectTopicAdapter(mDatasR, this);
        } else {
            adapterR.notifyDataSetChanged();
        }
        if (adapterF == null) {
            adapterF = new SelectTopicAdapter(mDatasF, this);
        } else {
            adapterF.notifyDataSetChanged();
        }
        FullyLinearLayoutManager linearLayoutManager = new FullyLinearLayoutManager(this, FullyLinearLayoutManager.VERTICAL, false);
        FullyLinearLayoutManager linearLayoutManager1 = new FullyLinearLayoutManager(this, FullyLinearLayoutManager.VERTICAL, false);
        focus_rcv.setLayoutManager(linearLayoutManager);
        focus_rcv.setAdapter(adapterF);
        recommend_rcv.setLayoutManager(linearLayoutManager1);
        recommend_rcv.setAdapter(adapterR);
        adapterR.setOnItemClickLister(new SelectTopicAdapter.OnItemClickLister() {
            @Override
            public void onItemClick(View view, int position) {
                Intent intent = new Intent();
                intent.setClass(SelecTopicActivity.this, PublishTrendActivity.class);
                intent.putExtra("type", "topic_select");
                Bundle bd = new Bundle();
                bd.putString("topic_id", mDatasR.get(position).getTopic_id());
                bd.putString("topic_title", mDatasR.get(position).getTopic_title());
                intent.putExtra("bundle", bd);
                setResult(RESULT_OK, intent);
                click_event();
                finish();
            }

            @Override
            public void onItemLongClick(View view, int position) {

            }
        });
        adapterF.setOnItemClickLister(new SelectTopicAdapter.OnItemClickLister() {
            @Override
            public void onItemClick(View view, int position) {
                Intent intent = new Intent();
                intent.setClass(SelecTopicActivity.this, PublishTrendActivity.class);
                intent.putExtra("type", "topic_select");
                Bundle bd = new Bundle();
                bd.putString("topic_id", mDatasF.get(position).getTopic_id());
                bd.putString("topic_title", mDatasF.get(position).getTopic_title());
                intent.putExtra("bundle", bd);
                setResult(RESULT_OK, intent);
                click_event();
                finish();
            }

            @Override
            public void onItemLongClick(View view, int position) {

            }
        });
        showProgressDialog("");
        initDatas();
    }

    private void click_event() {
    }

    private void initDatas() {
        Command.AllTopicCmd cmd = new Command.AllTopicCmd("1", "1");
        DynamicApiUtils.fetchTopicList(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(response -> {
                    if (response.code == 0) {
                        mDatasF.addAll(response.data.my);
                        mDatasR.addAll(response.data.list);
                        if (mDatasF.size() > 0) {
                            select_topic_focus_hint_rel.setVisibility(View.VISIBLE);
                        } else {
                            select_topic_focus_hint_rel.setVisibility(View.GONE);
                        }
                        if (mDatasR.size() > 0) {
                            select_topic_recommend_hint_rel.setVisibility(View.VISIBLE);
                        } else {
                            select_topic_recommend_hint_rel.setVisibility(View.GONE);
                        }
                        adapterR.notifyDataSetChanged();
                        adapterF.notifyDataSetChanged();
                    } else {
                        ToastUtil.toastShort(SelecTopicActivity.this, response.msg);
                    }
                    dismissProgressDialog();
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(SelecTopicActivity.this, throwable);
                });
    }

    @Override
    protected int layoutResId() {
        return 0;
    }

    @Override
    protected void initDataAndEvent() {

    }
}
