package com.yidianling.dynamic.thank;

import android.graphics.Color;
import android.os.Bundle;
import androidx.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.GlideCircleTransform;
import com.ydl.ydlcommon.base.BaseDialogFragment;
import com.ydl.ydlcommon.bean.ShareData;
import com.ydl.ydlcommon.view.dialog.CommonDialog;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.R2;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.thank.data.ZJservice;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * Created by jinkai on 16/5/10.
 */
public class ShowIntroduceDialogFragment extends BaseDialogFragment {


    @BindView(R2.id.sdv_head)
    ImageView mHead;
    @BindView(R2.id.name)
    TextView mName;
    @BindView(R2.id.introduce)
    TextView mIntroduce;
    @BindView(R2.id.changeimg)
    ImageView mChangeImg;
    @BindView(R2.id.changtext)
    TextView mChangeText;

    String docid;

    String UId;

    String listener_id;

    String name;

    String headUrl;

    String goodAt;

    private ZJservice zjservice;


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dynamic_fragment_dialog_show_introduce, container, false);
        ButterKnife.bind(this, view);
        init();
        return view;
    }

    public ShowIntroduceDialogFragment setPamrams(String docid, String UId, String listener_id, String name, String headUrl, String goodAt) {
        this.docid = docid;
        this.UId = UId;
        this.listener_id = listener_id;
        this.name = name;
        this.headUrl = headUrl;
        this.goodAt = goodAt;
        return this;
    }

    void init() {
        getService();
    }


    @OnClick({R2.id.ll_btn1, R2.id.ll_btn2, R2.id.iv_close})
    void click(View view) {
        if (view.getId() == R.id.ll_btn1) {
            if (zjservice.is_online.equals("1")) {

                H5Params h5Params = new H5Params(DynamicConstants.Companion.getZHUANJIA() + listener_id, null);
                ShareData shareData = new ShareData(DynamicConstants.Companion.getZHUANJIA() + listener_id, name, headUrl, goodAt);
                h5Params.setShareData(shareData);
                NewH5Activity.start(getActivity(), h5Params);
            } else if (zjservice.is_online.equals("2")) {

                if (!DynamicIn.INSTANCE.loginByOneKeyLogin(getActivity(),true)) {
                    return;
                }
                H5Params h5Params = new H5Params(DynamicConstants.Companion.getWWWXIADAN() + docid, null);
                NewH5Activity.start(getActivity(), h5Params);
            } else if (zjservice.is_online.equals("3")) {
                ToastUtil.toastShort("未开通微问诊");
            } else if (zjservice.is_online.equals("4")) {
                ToastUtil.toastShort("微问诊已满");
            }

        } else if (view.getId() == R.id.ll_btn2) {
            H5Params h5Params = new H5Params(DynamicIn.INSTANCE.getExpertHost() + docid, null);
            ShareData shareData = new ShareData(DynamicIn.INSTANCE.getShareExpertHost()+ docid, name + "咨询工作室", headUrl, goodAt);
            h5Params.setShareData(shareData);
            NewH5Activity.start(getActivity(), h5Params);
        } else if (view.getId() == R.id.iv_close) {
            dismiss();
        }
    }


    public void getService() {
        Command.Service service = new Command.Service(UId);
        DynamicApiUtils.getService(service)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    if (resp.code == 0) {
                        zjservice = resp.data;
                        mIntroduce.setText(zjservice.subhead);
                        mName.setText(name);
                        GlideApp.with(this)
                                .load(headUrl)
                                .transform(new GlideCircleTransform(getDialog().getContext()))
                                .into(mHead);

                        if (zjservice.is_online.equals("2")) {
                            mChangeImg.setImageResource(R.drawable.dynamic_icon_layer_chat);
                            mChangeText.setText("私聊");
                        }
                        if (zjservice.is_online.equals("3") || zjservice.is_online.equals("4")) {
                            mChangeImg.setImageResource(R.drawable.dynamic_icon_layer_chat_off);
                            mChangeText.setText("私聊");
                            mChangeText.setTextColor(Color.parseColor("#888888"));
                        }
                    } else {
                        ToastUtil.toastShort(resp.msg);
                    }
                }, throwable -> DynamicApiUtils.handleError(getActivity(), throwable));
    }

    private void showDialog(final String needRecharge) {

        new CommonDialog(getActivity())
                .setMessage("当前余额不足\n本次连接最少需要充值" +
                        needRecharge + "元")
                .setLeftOnclick("放弃", null)
                .setRightClick("充值", new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
//                        OuterEmptyImp.jumpToRechargeActivity(getActivity(),needRecharge+"");
                        DynamicIn.INSTANCE.rechargeIntent(getActivity());
//                        Intent intent = new Intent(getActivity(), RechargeActivity.class);
//                        intent.putExtra("money", needRecharge + "");
//                        startActivity(intent);
                    }
                }).show();
    }
}
