package com.yidianling.dynamic.topic.http

import com.ydl.ydlcommon.base.config.HttpConfig
import com.yidianling.dynamic.common.net.NetApiStore
import com.yidianling.dynamic.model.TopicDetailBean
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable

/**
 * @author yuanWai
 * @描述:话题接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/14
 */
class TopicHttpImpl : ITopicHttp{

    companion object {
        fun getInstance(): TopicHttpImpl {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = TopicHttpImpl()
    }

    private val netApiStore: NetApiStore by lazy {
        YDLHttpUtils.obtainApi(NetApiStore::class.java)
    }

    /**
     * 获取话题描述
     */
    override fun getTopicDetail(params: String): Observable<BaseAPIResponse<TopicDetailBean>> {
        return RxUtils.mapObservable(TopicDetailParam(""))
                .flatMap {netApiStore.getTopicDetail(HttpConfig.JAVA_BASE_URL+ "ask/topic-old?" + params)
                }
    }
}