package com.yidianling.dynamic.topic.topicDetail;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.actions.share.ShareUtils;
import com.ydl.ydlcommon.base.BaseMvpActivity;
import com.ydl.ydlcommon.ui.LogoLoadingView;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.utils.StatusBarUtils;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.R2;
import com.yidianling.dynamic.adapter.TopicDetailMemberAdapter;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.TopicDetailBean;
import com.yidianling.dynamic.publishTrend.PublishTrendActivity;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.trendList.TrendListInFragment;
import com.yidianling.dynamic.trendList.adapter.RecommendTopAdapter;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;


/**
 * 话题详情页
 * Refactor by Jim on 2017/12/27 0027.
 */
@Route(path = "/topic/detail")
public class TopicDetailActivity extends BaseMvpActivity<TopicDetailView, TopicDetailPresenterImpl> implements SwipeRefreshLayout.OnRefreshListener, TopicDetailView {


    @BindView(R2.id.topic_detail_top_bg_iv)
    ImageView mTopicDetailTopBgIv;
    @BindView(R2.id.topic_detail_title_tv)
    TextView mTopicDetailTitleTv;
    @BindView(R2.id.topic_detail_survey_tv)
    TextView mTopicDetailSurveyTv;
    @BindView(R2.id.topic_detail_visit_num_tv)
    TextView mTopicDetailVisitNumTv;
    @BindView(R2.id.topic_detail_visit_zj_tv)
    TextView mTopicDetailVisitZjTv;
    @BindView(R2.id.topic_detail_trend_num_tv)
    TextView mTopicDetailTrendNumTv;
    @BindView(R2.id.topic_detail_focus_tv)
    TextView mTopicDetailFocusTv;
    @BindView(R2.id.topic_detail_users_num_tv)
    TextView mTopicDetailUsersNumTv;
    @BindView(R2.id.topic_detail_users_rcv)
    RecyclerView mTopicDetailUsersRcv;
    @BindView(R2.id.topic_detail_users_rel)
    RelativeLayout mTopicDetailUsersRel;
    @BindView(R2.id.topic_detail_top_rel)
    RelativeLayout mTopicDetailTopRel;
    @BindView(R2.id.item_topic_detail_new_tv)
    TextView mItemTopicDetailNewTv;
    @BindView(R2.id.item_topic_detail_new_hint_tv)
    View mItemTopicDetailNewHintTv;
    @BindView(R2.id.item_topic_detail_new_rel)
    RelativeLayout mItemTopicDetailNewRel;
    @BindView(R2.id.item_topic_detail_hot_tv)
    TextView mItemTopicDetailHotTv;
    @BindView(R2.id.item_topic_detail_hot_hint_tv)
    View mItemTopicDetailHotHintTv;
    @BindView(R2.id.item_topic_detail_hot_rel)
    RelativeLayout mItemTopicDetailHotRel;
    @BindView(R2.id.topic_detail_type_lin)
    LinearLayout mTopicDetailTypeLin;
    @BindView(R2.id.app_bar)
    AppBarLayout mAppBar;
    @BindView(R2.id.topic_detail_vp)
    ViewPager mTopicDetailVp;
    @BindView(R2.id.swl)
    SwipeRefreshLayout mSwl;
    @BindView(R2.id.toolbar)
    Toolbar mToolbar;
    @BindView(R2.id.collapsingToolbarLayout)
    CollapsingToolbarLayout collapsingToolbarLayout;
    @BindView(R2.id.mine_next_iv)
    ImageView mMineNextIv;
    @BindView(R2.id.topic_detail_title_back_iv)
    ImageView mTopicDetailTitleBackIv;
    @BindView(R2.id.topic_detail_title_top_right_tv)
    ImageView mTopicDetailTitleTopRightTv;
    @BindView(R2.id.publish_trend_btn)
    FloatingActionButton mPublishTrendBtn;
    @BindView(R2.id.top_trends_rcv)
    RecyclerView topTrendsRcv;
    @BindView(R2.id.divide_line)
    View divideLine;
    @BindView(R2.id.v_loading)
    LogoLoadingView vLoading;


    private TopicDetailMemberAdapter adapter;
    private Fragment[] mFragments;
    String topicId, topicTitle;
    boolean isSplash;
    private int totalMembers;
    private int backgroundColor;
    private int selectTab;
    private RecommendTopAdapter mRecommendTopAdapter;

    private static final String IS_SPLASH = "isSplash";
    private static final String TOPIC_ID = "topic_id";

    public static Intent newIntent(Context context, boolean isSplash, String topicId) {
        Intent intent = new Intent(context, TopicDetailActivity.class);
        intent.putExtra(IS_SPLASH, isSplash);
        intent.putExtra(TOPIC_ID, topicId);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dynamic_activity_topic_detail);
        ButterKnife.bind(this);
        initDatas();
        initViews();
        fetchDatas();
        initNetLossView();
        StatusBarUtils.Companion.setCustomStatusView(this,mToolbar,true);
    }

    private void initNetLossView() {
        vLoading.setListener(new LogoLoadingView.LogoLoadingListener() {
            @Override
            public void onDataResetClick() {
                vLoading.setVisibility(View.VISIBLE);
                vLoading.setViewType(LogoLoadingView.TYPE_LOADING, null);

                initDatas();
                initViews();
                fetchDatas();
            }

            @Override
            public void onBackClick() {
                finish();
            }
        });
    }

    private void initViews() {
        setSupportActionBar(mToolbar);
        mSwl.setOnRefreshListener(this);
        mSwl.setColorSchemeResources(R.color.platform_main_theme);
        mSwl.setProgressViewOffset(false, 0, 200);
        topTrendsRcv.setLayoutManager(new LinearLayoutManager(this));
        topTrendsRcv.setAdapter(mRecommendTopAdapter);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        mTopicDetailUsersRcv.setLayoutManager(linearLayoutManager);
        mTopicDetailUsersRcv.setAdapter(adapter);
        mTopicDetailVp.setAdapter(new FragmentPagerAdapter(getSupportFragmentManager()) {
            @Override
            public Fragment getItem(int position) {
                return mFragments[position];
            }

            @Override
            public int getCount() {
                return mFragments.length;
            }
        });
        mTopicDetailVp.setOffscreenPageLimit(2);
        mTopicDetailVp.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                switch (position) {
                    case 0:
                        setTabSelection(0);
                        break;
                    case 1:
                        setTabSelection(1);
                        break;

                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mAppBar.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener() {
            @Override
            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (verticalOffset == 0) {
                    mSwl.setEnabled(true);
                } else {
                    mSwl.setEnabled(false);
                }
                LogUtil.d("tool bar size: " + mToolbar.getHeight());
                if (verticalOffset <= (-appBarLayout.getTotalScrollRange() + mToolbar.getHeight() / 2)) {
                    if (backgroundColor != R.color.dynamic_white) {
                        mToolbar.setBackgroundColor(getResources().getColor(R.color.dynamic_white));
                        alPhaAnimation(mToolbar, 0, 1, null);
                        mTopicDetailTitleBackIv.setImageResource(R.drawable.platform_common_back);
                        mTopicDetailTitleTopRightTv.setImageResource(R.drawable.platform_common_notice_more_un);
                        backgroundColor = R.color.dynamic_white;
                    }
                    collapsingToolbarLayout.setTitle(topicTitle);
                    //使用下面两个CollapsingToolbarLayout的方法设置展开透明->折叠时你想要的颜色
                    collapsingToolbarLayout.setExpandedTitleColor(getResources().getColor(R.color.dynamic_transparent));
                    collapsingToolbarLayout.setCollapsedTitleTextColor(getResources().getColor(R.color.dynamic_black));
                } else if (verticalOffset >= -appBarLayout.getTotalScrollRange() / 5) {
                    collapsingToolbarLayout.setTitle("");
                    if (backgroundColor != R.color.dynamic_transparent) {
                        alPhaAnimation(mToolbar, 1, 0f, new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                super.onAnimationEnd(animation);
                                mToolbar.setBackgroundColor(getResources().getColor(R.color.dynamic_transparent));
                                mToolbar.setAlpha(1f);
                                mTopicDetailTitleBackIv.setImageResource(R.drawable.dynamic_titlebar_back2);
                                mTopicDetailTitleTopRightTv.setImageResource(R.drawable.dynamic_more_green2);
                            }
                        });
                        backgroundColor = R.color.dynamic_transparent;
                    }
                } else {
                    if (backgroundColor != R.color.dynamic_transparent) {
                        mToolbar.setBackgroundColor(getResources().getColor(R.color.dynamic_transparent));
                        mToolbar.setAlpha(1f);
                        mTopicDetailTitleBackIv.setImageResource(R.drawable.dynamic_titlebar_back2);
                        mTopicDetailTitleTopRightTv.setImageResource(R.drawable.dynamic_more_green2);
                        backgroundColor = R.color.dynamic_transparent;
                    }
                    collapsingToolbarLayout.setTitle("");
                }
            }
        });
    }

    private void alPhaAnimation(View v, float originAlpha, float desAlpha, @Nullable AnimatorListenerAdapter listener) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(v, "alpha", originAlpha, desAlpha);
        animator.setDuration(200);
        animator.start();
        if (listener != null) {
            animator.addListener(listener);
        }
    }

    private void initDatas() {
        selectTab = 0;
        backgroundColor = -1;
        totalMembers = 0;
        topicId = getIntent().getStringExtra("topic_id");
        isSplash = getIntent().getBooleanExtra("isSplash", false);
        adapter = new TopicDetailMemberAdapter(this);
        mFragments = new Fragment[]{TrendListInFragment.newInstance("1", topicId, "default", "0"),
                TrendListInFragment.newInstance("2", topicId, "default", "0")};
        mRecommendTopAdapter = new RecommendTopAdapter(this);
    }

    @NonNull
    @Override
    public TopicDetailPresenterImpl createPresenter() {
        return new TopicDetailPresenterImpl();
    }


    @Override
    public void onRefresh() {
        mSwl.setRefreshing(true);
        fetchDatas();
        if (selectTab == 0) {
            LogUtil.d("send to refresh");
            Message message = mHandler1.obtainMessage(DynamicConstants.TOPIC_DETAIL_NEW_REFRESH, topicId);
            message.sendToTarget();
        } else if (selectTab == 1) {
            LogUtil.d("send to refresh");
            Message message = mHandler2.obtainMessage(DynamicConstants.TOPIC_DETAIL_HOT_REFRESH, topicId);
            message.sendToTarget();
        }
    }

    private Handler mHandler1;
    private Handler mHandler2;

    public void setHandler(Handler handler, String tab) {
        LogUtil.d("tab: " + tab);
        if (tab.equals("1")) {
            mHandler1 = handler;
        } else if (tab.equals("2")) {
            mHandler2 = handler;
        }
    }


    @OnClick({R2.id.item_topic_detail_new_rel, R2.id.item_topic_detail_hot_rel, R2.id.publish_trend_btn, R2.id.topic_detail_focus_tv,
            R2.id.topic_detail_users_rel, R2.id.topic_detail_title_top_right_tv, R2.id.topic_detail_title_back_iv})
    void doClick(View view) {
        if (view.getId() == R.id.item_topic_detail_new_rel) {
            mTopicDetailVp.setCurrentItem(0);
            setTabSelection(0);
        } else if (view.getId() == R.id.item_topic_detail_hot_rel) {

            mTopicDetailVp.setCurrentItem(1);
            setTabSelection(1);
        } else if (view.getId() == R.id.publish_trend_btn) {
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(TopicDetailActivity.this,true)) {
                Intent intent = new Intent();
                intent.setClass(TopicDetailActivity.this, PublishTrendActivity.class);
                Bundle bundle = new Bundle();
                bundle.putString(DynamicConstants.PUBLISH_TYPE, "topic_publish");
                bundle.putString("topic_id", topicId);
                bundle.putString("topic_title", topicTitle);
                intent.putExtra("bundle", bundle);
                startActivity(intent);
            }
        } else if (view.getId() == R.id.topic_detail_focus_tv) {
            if (DynamicIn.INSTANCE.loginByOneKeyLogin(TopicDetailActivity.this,true)) {
                getPresenter().focusTopic(topicId);
            }
        } else if (view.getId() == R.id.topic_detail_users_rel) {
            String url = DynamicConstants.Companion.getTOPIC_DETAIL_H5() + topicId;
            NewH5Activity.start(getMContext(), new H5Params(url, null));
        } else if (view.getId() == R.id.topic_detail_title_top_right_tv) {
            if (share == null) {
                return;
            }
            ShowCustomShareDialog(share.title, share.shareUrl, share.desc, share.cover);
        } else if (view.getId() == R.id.topic_detail_title_back_iv) {

            back();
        }
    }

    private void back() {
        if (isSplash) {
            DynamicIn.INSTANCE.mainIntent(this);
        }
        finish();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            back();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }


    private void ShowCustomShareDialog(final String share_title, final String share_url, final String share_context, final String share_head) {
        View view = getLayoutInflater().inflate(R.layout.dynamic_share_select_dialog,
                null);
        final Dialog dialog = new Dialog(this,
                R.style.transparentFrameWindowStyle);
        dialog.setContentView(view, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));
        Window window = dialog.getWindow();
        // 设置显示动画
        window.setWindowAnimations(R.style.main_menu_animstyle);
        WindowManager.LayoutParams wl = window.getAttributes();
        wl.x = 0;
        wl.y = getWindowManager().getDefaultDisplay().getHeight();
        // 以下这两句是为了保证按钮可以水平满屏
        wl.width = ViewGroup.LayoutParams.MATCH_PARENT;
        wl.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        // 设置显示位置
        dialog.onWindowAttributesChanged(wl);
        // 设置点击外围解散
        dialog.setCanceledOnTouchOutside(true);
        LinearLayout wechat_lin = (LinearLayout) view.findViewById(R.id.share_weichat);
        LinearLayout pyq_lin = (LinearLayout) view.findViewById(R.id.share_pyq);
        LinearLayout qqzone_lin = (LinearLayout) view.findViewById(R.id.share_qqzone);
        LinearLayout qq_lin = (LinearLayout) view.findViewById(R.id.share_qq);
        LinearLayout backhome_lin = (LinearLayout) view.findViewById(R.id.share_back_home);
        if (!TopicDetailActivity.this.isFinishing() && !dialog.isShowing()) {
            dialog.show();
        }
        wechat_lin.setOnClickListener(v -> {
            ShareUtils.INSTANCE.shareTo(SHARE_MEDIA.WEIXIN, TopicDetailActivity.this, share_title, share_url, share_context, share_head);
            dialog.dismiss();
        });

        pyq_lin.setOnClickListener(v -> {
            ShareUtils.INSTANCE.shareTo(SHARE_MEDIA.WEIXIN_CIRCLE, TopicDetailActivity.this, share_title, share_url, share_context, share_head);
            dialog.dismiss();
        });
        qqzone_lin.setOnClickListener(v -> {
            ShareUtils.INSTANCE.shareTo(SHARE_MEDIA.QZONE, TopicDetailActivity.this, share_title, share_url, share_context, share_head);
            dialog.dismiss();
        });
        qq_lin.setOnClickListener(v -> {
            ShareUtils.INSTANCE.shareTo(SHARE_MEDIA.QQ, TopicDetailActivity.this, share_title, share_url, share_context, share_head);
            dialog.dismiss();
        });
        backhome_lin.setOnClickListener(v -> {
            DynamicIn.INSTANCE.mainIntent(this);
            dialog.dismiss();
        });
    }

    private void resetText() {
        mItemTopicDetailNewTv.setTextColor(getResources().getColor(R.color.dynamic_text_gray));
        mItemTopicDetailNewHintTv.setBackgroundColor(getResources().getColor(R.color.dynamic_white));
        mItemTopicDetailHotTv.setTextColor(getResources().getColor(R.color.dynamic_text_gray));
        mItemTopicDetailHotHintTv.setBackgroundColor(getResources().getColor(R.color.dynamic_white));
    }

    private void setTabSelection(int index) {
        // 重置按钮
        resetText();
        switch (index) {
            case 0:
                if (mTopicDetailVp.getCurrentItem() != 0) {
                    mTopicDetailVp.setCurrentItem(0);
                }
                selectTab = 0;
                mItemTopicDetailNewTv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                mItemTopicDetailNewHintTv.setBackgroundColor(getResources().getColor(R.color.platform_main_theme));
                break;
            case 1:
                if (mTopicDetailVp.getCurrentItem() != 1) {
                    mTopicDetailVp.setCurrentItem(1);
                }
                selectTab = 1;
                mItemTopicDetailHotTv.setTextColor(getResources().getColor(R.color.platform_main_theme));
                mItemTopicDetailHotHintTv.setBackgroundColor(getResources().getColor(R.color.platform_main_theme));
                break;

        }
    }

    private void fetchDatas() {
        getPresenter().getTopicDetail(topicId);
    }

    @Override
    public void showToast(String msg) {
    }

    private TopicDetailBean.Share share;

    @Override
    public void showTopicHeadDetail(TopicDetailBean topicDetail) {
        topicTitle = topicDetail.topic.title;
        totalMembers = topicDetail.totalMembers;
        String is_focused = topicDetail.topic.isFocused;
        String cover = topicDetail.topic.cover;
        mTopicDetailTitleTv.setText(topicDetail.topic.title);
        mTopicDetailSurveyTv.setText(topicDetail.topic.description);
        mTopicDetailVisitNumTv.setText("" + topicDetail.topic.visitCount);
        mTopicDetailTrendNumTv.setText("" + topicDetail.topic.postsCount);
        GlideApp.with(TopicDetailActivity.this)
                .load(cover)
                .placeholder(R.drawable.dynamic_default_img)
                .error(R.drawable.dynamic_default_img)
                .into(mTopicDetailTopBgIv);
        mTopicDetailFocusTv.setBackgroundResource("1".equals(is_focused) ? R.drawable.dynamic_focused_topic_detail_bg : R.drawable.dynamic_focus_topic_detail_bg);
        mTopicDetailFocusTv.setTextColor(getResources().getColor("1".equals(is_focused) ? R.color.platform_white : R.color.platform_but_text_color));
        mTopicDetailFocusTv.setText("1".equals(is_focused) ? this.getString(R.string.dynamic_trend_foucused) : "+" + this.getString(R.string.dynamic_trend_foucus));
        if (!"2".equals(topicId)) {
            mTopicDetailFocusTv.setVisibility(View.VISIBLE);
        }
        adapter.setDatas(topicDetail.members);
        mTopicDetailUsersNumTv.setText(topicDetail.totalMembers + "人");
        share = topicDetail.share;
        if (topicDetail.top_data != null && topicDetail.top_data.size() > 0) {
            divideLine.setVisibility(View.VISIBLE);
            topTrendsRcv.setVisibility(View.VISIBLE);
            mRecommendTopAdapter.setExtData(topicDetail.top_data);
            mRecommendTopAdapter.notifyDataSetChanged();
        } else {
            divideLine.setVisibility(View.GONE);
            topTrendsRcv.setVisibility(View.GONE);
        }
    }

    @Override
    public void showLoadingView(String message) {
        if (mSwl.isRefreshing()) {
            return;
        }
        vLoading.setVisibility(View.VISIBLE);
        vLoading.setViewType(LogoLoadingView.TYPE_LOADING, null);
    }

    @Override
    public void hideLoadingView() {
        vLoading.setVisibility(View.GONE);
    }

    @Override
    public void hideProgressView() {
        vLoading.setVisibility(View.GONE);
        if (mSwl.isRefreshing()) {
            mSwl.setRefreshing(false);
        }
    }

    @Override
    public void showFocusResult(Focus result) {
        //关注成功
        String status = String.valueOf(result.status);//1关注，2取消关注
        //关注成功
        if ("1".equals(status)) {
            BuryPointUtils.getInstance().createMap()
                    .put("theme_name", topicTitle)
                    .put("theme_ID", topicId)
                    .burryPoint("Theme_attention");
            totalMembers += 1;
            mTopicDetailUsersNumTv.setText(totalMembers + "人");
            mTopicDetailFocusTv.setBackgroundResource(R.drawable.dynamic_focused_topic_detail_bg);
            mTopicDetailFocusTv.setText(this.getString(R.string.dynamic_trend_foucused));
            TopicDetailBean.Member member = new TopicDetailBean.Member();
            member.head = DynamicIn.INSTANCE.getUserInfo().getHead();
            member.uid = DynamicIn.INSTANCE.getUserInfo().getUid() + "";
            adapter.addData(0, member);
        } else {
            totalMembers = totalMembers - 1;
            mTopicDetailUsersNumTv.setText(totalMembers + "人");
            mTopicDetailFocusTv.setBackgroundResource(R.drawable.dynamic_focus_topic_detail_bg);
            mTopicDetailFocusTv.setText("+" + this.getString(R.string.dynamic_trend_foucus));
            if (adapter.getDatas() != null && adapter.getDatas().size() > 0) {
                for (TopicDetailBean.Member m : adapter.getDatas()) {
                    if (m.uid.equals(DynamicIn.INSTANCE.getUserInfo().getUid())) {
                        adapter.removeData(m);
                    }
                }
            }

        }
    }

    @Override
    public void showErrorView() {
        vLoading.setVisibility(View.VISIBLE);
        vLoading.setViewType(LogoLoadingView.TYPE_NET_LOSS, "哎呦，网络开小差了");
    }

    @Override
    public void showFocusError(Throwable throwable) {
        vLoading.setVisibility(View.VISIBLE);
        vLoading.setViewType(LogoLoadingView.TYPE_NET_LOSS, "哎呦，网络开小差了");
    }

    @Override
    protected int layoutResId() {
        return 0;
    }

    @Override
    protected void initDataAndEvent() {

    }
}