package com.yidianling.dynamic.topic.topicDetail;

import android.content.Context;

import com.ydl.ydlcommon.mvp.base.SimplePresenter;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.common.tool.ApiThrowable;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.TopicDetailBean;


/**
 * Created by Jim on 2017/12/27 0027.
 */

public class TopicDetailPresenterImpl extends SimplePresenter<TopicDetailView> implements ITopicDetailPresenter, ITopicDetailPresenter.ITopicDetailInteracor {

    private TopicDetailInteractor mInteractor;

    public TopicDetailPresenterImpl() {
        mInteractor = new TopicDetailInteractor(this);
    }

    public void getTopicDetail(String topicId) {
        mView.showLoadingView("");
        mInteractor.getTopicDetail(topicId,mView);
    }

    public void focusTopic(String topicId) {
        mView.showLoadingView("");
        mInteractor.focusTopic(topicId,mView);
    }

    //结果回调
    @Override
    public void onTopicDetailDataFetched(TopicDetailBean topicDetail) {
        if (mView != null) {
            mView.hideProgressView();
            mView.hideLoadingView();
            mView.showTopicHeadDetail(topicDetail);
        }
    }


    @Override
    public void onTopicDetailDataFetchFailed(Throwable throwable) {
        mView.showErrorView();
        if (throwable instanceof ApiThrowable) {
            mView.showToast(throwable.getMessage());
        } else {
            DynamicApiUtils.handleError((Context) mView, throwable);
        }
    }

    @Override
    public void onFocusResultFetched(Focus resp) {
        if (mView != null) {
            mView.hideProgressView();
            mView.hideLoadingView();
            mView.showFocusResult(resp);
        }
    }

    @Override
    public void onFocusFailed(Throwable throwable) {
        if (throwable instanceof ApiThrowable) {
            mView.showToast(throwable.getMessage());
        } else {
            DynamicApiUtils.handleError((Context) mView, throwable);
        }
    }
}
