package com.yidianling.dynamic.trendList.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.ydl.ydlcommon.view.BaseViewHolder;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.ITopTrends;
import com.yidianling.dynamic.trendsDetail.TrendsDetailActivity;

import java.util.List;

/**
 * Created by Jim on 2017/10/31 0031.
 */

public class RecommendTopAdapter<T extends ITopTrends> extends RecyclerView.Adapter<BaseViewHolder> {

    private List<T> mExtData;
    private Context mContext;

    public RecommendTopAdapter(Context context){
        this.mContext=context;
    }

    public RecommendTopAdapter(List<T> extData,Context context){
        this.mContext=context;
        this.mExtData=extData;
    }

    public void setExtData(List<T> extData){
        this.mExtData=extData;
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(mContext).inflate(R.layout.dynamic_item_last_trend_top,parent,false);
        return new BaseViewHolder(view);
    }

    @Override
    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (mExtData!=null&&mExtData.size()>0){
            holder.setText(R.id.text_title,mExtData.get(position).getTitle());
            holder.setOnClickListener(R.id.text_title, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        TrendsDetailActivity.start(mContext,Integer.valueOf(mExtData.get(position).getId()),false,false,false,false,0);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
            });
        }

        if (position==mExtData.size()-1){
            holder.setVisible(R.id.line,false);
        }
    }

    @Override
    public int getItemCount() {
        return mExtData!=null&&mExtData.size()>0?mExtData.size():0;
    }
}
