package com.yidianling.home.constants

import android.content.Context
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.home.model.bean.*
import io.reactivex.Observable

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 壹点灵首页约束类
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class IHomeBaseContract {

    interface View : IView {
        /**
         * 首页数据回调接口
         */
        fun homeDataResponse(list: MutableList<HomePagerDataBean>)

        /**
         * 头部数据回调
         */
        fun homeHeadResponse(homeHeaderBean: HomeHeaderBean)

        /**
         * 首页数据请求失败接口
         */
        fun homeDataFail(msg: String)

        /**
         * 获取倾述数据回调
         */
        fun confideDataResponse(data: HomeConfideBean, selectPosition: Int)

        /**
         * 获取咨询数据回调
         */
        fun consultDataResponse(data: HomeConsultBean, selectPosition: Int)

        /**
         * 问答模块数据回调
         */
        fun askDataResponse(data: HomeAskBean, position: Int)

        /**
         * 首页问答 - 点赞
         */
        fun askZan(position: Int, index: Int, id: String)

        /**
         * 首页问答 - 关注
         */
        fun askFocus(position: Int, id: String)

        /**
         * 获取倾述列表数据
         * @param type 倾述类型
         * @param selectPosition 选中的position
         */
        fun getConfideData(type: String, selectPosition: Int)

        /**
         * 获取咨询列表数据
         */
        fun getConsultData(type: String, selectPosition: Int)

        fun showHomeProgress()

        fun showRefreshLayout()

        fun dismissHomeProgress()

        fun resetModuleTabPosition()


    }

    interface Presenter<V : IView> : IPresenter<V> {
        /**
         * 获取首页本地缓存
         */
        fun localHomeData(context: Context, fileName: String)

        /**
         * 刷新首页数据请求
         */
        fun refreshHomeData()

        /**
         * 获取首页数据请求
         */
        fun loadHomeData()

        /**
         *获取倾述列表
         */
        fun getConfideData(type: String, selectPosition: Int)

        /**
         *获取咨询列表
         */
        fun getConsultData(type: String, selectPosition: Int, isCancelHome: Boolean = true)

        /**
         * 首页问答 - 点赞
         */
        fun askZan(position: Int, index: Int, id: String)

        /**
         * 首页问答 - 关注
         */
        fun askFocus(position: Int, id: String)

        /**
         * 保存临时数据
         */
        fun saveTempData(list: MutableList<HomePagerDataBean>)

        /**
         * 获取临时数据
         */
        fun getHomeItemFromTempData(dataBean: HomeItemBaseBean, type: Int): Any
    }

    interface Model : IModel {
        /**
         * 首页头部 分类&Banner请求
         */
        fun headerRequest(): Observable<HomeHeaderBean>

        /**
         * 首页电台请求
         */
        fun fmRequest(): Observable<HomeFMBean>

        /**
         * 首页课程请求
         */
        fun courseRequest(): Observable<HomeCourseBean>

        /**
         * 首页测试题请求
         */
        fun testRequest(): Observable<BaseAPIResponse<MutableList<HomeTestItemBean>>>

        /**
         * 首页咨询请求
         */
        fun consultRequest(category: String): Observable<HomeConsultBean>

        /**
         * 首页倾听请求
         */
        fun confideRequest(goodType: String): Observable<HomeConfideBean>

        /**
         * 首页问答请求
         */
        fun askRequest(): Observable<HomeAskBean>

        /**
         * 首页文章请求
         */
        fun articleRequest(): Observable<HomeArticleBean>

        /**
         * 首页问答 - 点赞
         */
        fun askZan(id: String): Observable<AskResultBean>

        /**
         * 首页问答 - 关注
         */
        fun askFocus(id: String): Observable<AskResultBean>
    }
}