package com.yidianling.home.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.data.PlatformDataManager
import com.yidianling.home.R
import com.yidianling.home.constract.YdlHomeViewHolderConstract
import com.yidianling.home.event.HomeImpl
import com.yidianling.home.model.bean.HomeAskBean
import com.yidianling.home.model.bean.HomeConfideBean
import com.yidianling.home.model.bean.HomeConsultBean
import com.yidianling.home.model.bean.HomePagerDataBean
import com.yidianling.home.ui.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 壹点零首页适配器
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class YdlHomeAdapter(
    private val mContext: Context,
    private var homeEvent: HomeImpl,
    private var list: ArrayList<HomePagerDataBean>
) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private val mInflater: LayoutInflater = LayoutInflater.from(mContext)
    /**
     * 倾述item的position
     *
     */
    private var confidePosition = -1
    /**
     * 咨询条目 position
     */
    private var consultPosition = -1
    /**
     * 倾述模块中tab上次选中的下标
     */
    var confideSelectPosition = 0
    /**
     * 咨询模块中tab上次选中的下标
     */
    var consultSelectPosition = 0

    fun updateItems(list: MutableList<HomePagerDataBean>) {
        if (null == this.list || this.list!!.isEmpty()) {
            this.list = ArrayList()
        } else {
            this.list.clear()
        }
        this.list.addAll(list)
        //重置标记位
        confidePosition = -1
        consultPosition = -1
        notifyDataSetChanged()
    }

    /**
     * 更新倾诉模块数据
     */
    fun updateConfideData(data: HomeConfideBean, selectPosition: Int) {
        if (confidePosition == -1) {
            return
        }
        list[confidePosition].confideBean = data
        this.confideSelectPosition = selectPosition
        notifyItemChanged(confidePosition)
    }

    /**
     * 更新咨询模块数据
     */
    fun updateConsultData(data: HomeConsultBean, selectPosition: Int) {
        if (consultPosition == -1) {
            return
        }
        list[consultPosition].consultBean = data
        this.consultSelectPosition = selectPosition
        notifyItemChanged(consultPosition)
    }

    /**
     * 更新问答模块数据
     */
    fun updateAskData(data: HomeAskBean, position: Int) {
        list[position].askBean = data
        notifyItemChanged(position)
    }

    override fun getItemViewType(position: Int): Int {
        if (position < list.size) {
            return list[position].type!!
        } else {
            return YdlHomeViewHolderConstract.FOOTER_VIEW
        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        when (viewType) {
            //顶部图片banner
            YdlHomeViewHolderConstract.HOME_IMAGE_BANNER -> {
                return HomeImageBannerViewHolder(HomeImageBannerView(mContext, homeEvent))
            }
            //顶部预约专家，即时倾诉，心理测试按钮模块
            YdlHomeViewHolderConstract.BUTTON_BANNER_VIEW -> {
                return HomeButtonBannerViewHolder(HomeButtonBannerView(mContext, homeEvent))
            }
            //倾诉*排解模块
            YdlHomeViewHolderConstract.CONFIDE_VIEW -> {
                return HomeEmptyViewHolder(HomeEmptyView(mContext))
            }
            //课程*成长模块
            YdlHomeViewHolderConstract.COURSE_VIEW -> {
                return HomeCourseViewHolder(HomeCourseView(mContext, homeEvent))
            }
            //解忧*问答模块
            YdlHomeViewHolderConstract.ASSUAGE_GRIEF_VIEW -> {
                return HomeAssuageGriefViewHolder(HomeAssuageGriefView(mContext, homeEvent))
            }
            //文章*阅读模块
            YdlHomeViewHolderConstract.ARTICLE_VIEW -> {
                return HomeArticleViewHolder(HomeArticleView(mContext, homeEvent))
            }
            //咨询模块
            YdlHomeViewHolderConstract.CONSULT_VIEW -> {
                return HomeConsultViewHolder(HomeConsultView(mContext, homeEvent))
            }
            //测试模块
            YdlHomeViewHolderConstract.TEST_VIEW -> {
                return HomeTestViewHolder(HomeTestView(mContext, homeEvent))
            }
            //底部提示语模块
            else -> {
                val view = mInflater.inflate(R.layout.home_footer_view, parent, false)
                return FooterViewViewHolder(view)
            }
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is HomeImageBannerViewHolder -> {
                holder.imageBannerView.initData(list[position])
            }
            //顶部预约专家，即时倾诉，心理课堂，心理测试按钮模块
            is HomeButtonBannerViewHolder -> {
                holder.buttonBannerView.initData(
                    list[position].headerBean?.askCategoryData
                )
            }
            //倾诉*排解模块
//            is HomeConfideViewHolder -> {
//                if (!TextUtils.isEmpty(ffrom) && ffrom.endsWith("huawei")) {
//                    val parm = holder.itemView.layoutParams
//                    parm.height = 0
//                    holder.itemView.layoutParams = parm
//                } else {
//                    holder.confideViewView.setTitle(
//                        list[position].headerBean?.listenCategoryDate,
//                        confideSelectPosition
//                    )
//                    holder.confideViewView.setConfideExpertInfoView(list[position].confideBean?.body)
//                    confidePosition = position
//                }
//            }
            //课程*成长模块
            is HomeCourseViewHolder -> {
                holder.courseViewView.initData(list[position].courseBean?.list)

            }
            //解忧*问答模块
            is HomeAssuageGriefViewHolder -> {
                holder.assuageGriefViewView.initData(position, list[position].askBean?.data)

            }
            //文章*阅读模块
            is HomeArticleViewHolder -> {
                holder.articleViewView.initData(list[position].articleBean?.list)
            }
            //咨询模块
            is HomeConsultViewHolder -> {
                holder.consultView.setTitle(
                    list[position].headerBean?.consultCategoryData,
                    consultSelectPosition
                )
                holder.consultView.setConsultInfoView(
                    list[position].consultBean?.list,
                    list[position].headerBean?.consultCategoryData?.get(consultSelectPosition)
                )
                consultPosition = position
            }
            //测试模块
            is HomeTestViewHolder -> {
                holder.testView.initData(list[position].testListBean)
            }
        }
    }

    override fun getItemCount(): Int {
        return list.size
    }

    inner class HomeImageBannerViewHolder(val imageBannerView: HomeImageBannerView) :
        RecyclerView.ViewHolder(imageBannerView)

    /**
     * 顶部预约专家，即时倾诉，心理测试按钮模块 ViewHolder
     */
    inner class HomeButtonBannerViewHolder(val buttonBannerView: HomeButtonBannerView) :
        RecyclerView.ViewHolder(buttonBannerView)

    /**
     * 咨询模块 ViewHolder
     */
    inner class HomeConsultViewHolder(val consultView: HomeConsultView) :
        RecyclerView.ViewHolder(consultView)

    /**
     * 倾诉*排解模块 ViewHolder
     */
    inner class HomeConfideViewHolder(val confideViewView: HomeConfideView) :
        RecyclerView.ViewHolder(confideViewView)

    inner class HomeEmptyViewHolder(val emptyView: HomeEmptyView) :
        RecyclerView.ViewHolder(emptyView)

    /**
     * 课程*成长模块 ViewHolder
     */
    inner class HomeCourseViewHolder(val courseViewView: HomeCourseView) :
        RecyclerView.ViewHolder(courseViewView)

    /**
     * 测试模块 ViewHolder
     */
    inner class HomeTestViewHolder(val testView: HomeTestView) : RecyclerView.ViewHolder(testView)

    /**
     * 解忧*问答模块 ViewHolder
     */
    inner class HomeAssuageGriefViewHolder(val assuageGriefViewView: HomeAssuageGriefView) :
        RecyclerView.ViewHolder(assuageGriefViewView)

    /**
     * 文章*阅读模块 ViewHolder
     */
    inner class HomeArticleViewHolder(val articleViewView: HomeArticleView) :
        RecyclerView.ViewHolder(articleViewView)

    /**
     * 底部提示语模块 ViewHolder
     */
    inner class FooterViewViewHolder(val footerView: View) : RecyclerView.ViewHolder(footerView)
}