package com.yidianling.home.ui.view

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeArticleBean
import kotlinx.android.synthetic.xlzx.home_article_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 文章*阅读模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeArticleView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    LinearLayout(mContext) {

    private var cacheList: ArrayList<HomeArticleBean.Bean> = ArrayList()

    init {
        initView()
    }

    private fun initView() {
        orientation = VERTICAL
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_article_view, this)
        homeModuleArticleViewHomeCommonTitleView.setTitle("主题阅读")
        homeModuleArticleViewHomeCommonTitleView.setMoreText("更多阅读")
        homeModuleArticleViewHomeCommonTitleView.setOnClickListener {
            homeEvent?.articleMoreClick()
        }
    }

    fun initData(list: List<HomeArticleBean.Bean>?) {
        //添加View
        if (list == null) {
            return
        }
        if (cacheList.size != list?.size) {
            cacheList.clear()
            cacheList.addAll(list!!)
            updateHomeArticleItemViewNumber()
        }
        //刷新数据
        for (index in 0 until childCount) {
            val itemView = getChildAt(index)
            if (itemView is HomeArticleItemView) {
                itemView.updateData(list[index - 1])
                // 最后一个隐藏底部横线
                if (index == childCount - 1) {
                    itemView.hideBottomLine()
                }
            }
        }
    }

    /**
     * 更新itemView的数量以适应新的数据集
     */
    private fun updateHomeArticleItemViewNumber() {
        var childCountRecord = childCount - 1 //减1是因为第一个子View是标题View
        while (cacheList.size > childCountRecord) {
            addView(HomeArticleItemView(mContext, homeEvent))
            childCountRecord++
        }
        while (cacheList.size < childCountRecord && getChildAt(childCountRecord - 1) is HomeArticleItemView) {
            removeViewAt(childCountRecord - 1)
            childCountRecord--
        }
    }
}