package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.Color
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.RelativeLayout
import com.ydl.ydlcommon.data.PlatformDataManager
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import kotlinx.android.synthetic.xlzx.home_button_banner_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 顶部预约专家，即时倾诉，心理课堂，心理测试按钮模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeButtonBannerView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) :
    LinearLayout(mContext) {

    init {
        initView()
    }

    private fun initView() {
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_button_banner_view, this)

        homeModuleButtonBannerFirst.setOnClickListener {
            homeEvent?.reservationExpertsClick()
        }
        homeModuleButtonBannerSecond.setOnClickListener {
            homeEvent?.askMoreClick()
        }
        homeModuleButtonBannerThird.setOnClickListener {
            homeEvent?.articleMoreClick()
        }
        homeModuleButtonBannerFourth.setOnClickListener {
            homeEvent?.psychologyTestClick()
        }
    }


    fun initData(
        homeCategory: List<HomeHeaderBean.AskCategoryDataBean>?
    ) {
        homeEvent?.let { home_category_view.setEvent(it) }
        home_category_view.initData(homeCategory)


    }
}