package com.yidianling.home.ui.view

import android.content.Context
import androidx.constraintlayout.widget.ConstraintLayout
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.ydlcommon.data.PlatformDataManager
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import kotlinx.android.synthetic.xlzx.home_common_title_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 首页通用标题
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/14
 */
class HomeCommonTitleView(private val mContext: Context, private val attributeSet: AttributeSet) :
    ConstraintLayout(mContext, attributeSet) {
    private val ffrom = PlatformDataManager.getRam().getChannelName()

    init {
        initView()
    }

    private fun initView() {
        View.inflate(mContext, R.layout.home_common_title_view, this)
    }

    fun setTitle(title: String) {
        homeModuleCommonTitleViewTitle.text = title
    }

    fun setMoreText(text: String) {
        homeModuleCommonTitleViewMorell.visibility = View.VISIBLE
        homeModuleCommonTitleViewMoreText.text = text
    }

    fun setTopMargin(topMargin: Int) {
        val params = layoutParams as MarginLayoutParams
        params.topMargin = RxImageTool.dp2px(topMargin.toFloat())
        layoutParams = params
    }
}