package com.yidianling.home.ui.view

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.LinearLayout
import com.ydl.ydlcommon.utils.YdlBuryPointUtil
import com.ydl.ydlcommon.view.banner.GlideImageLoader
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import com.yidianling.home.model.bean.HomePagerDataBean
import kotlinx.android.synthetic.xlzx.home_image_banner_view.view.*

class HomeImageBannerView(val mContext: Context, val homeEvent: IHomeBaseEvent) : LinearLayout(mContext) {

    init {
        initView()
    }

    fun initView() {
        val params = LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        ) as MarginLayoutParams

        params.topMargin = RxImageTool.dp2px(12f)

        layoutParams = params
        View.inflate(mContext, R.layout.home_image_banner_view, this)

        initBannerLayout()

    }

    private fun initBannerLayout() {
        val bannerWidth = RxDeviceTool.getScreenWidth(mContext) - RxImageTool.dp2px(16f) * 2
        val bannerLayoutParams = FrameLayout.LayoutParams(
            bannerWidth,
            (bannerWidth * 131 / 343)
        )
        banner_search.layoutParams = bannerLayoutParams

//        banner_search.setIndicatorBottomPadding(5)
    }

    fun initData(bean: HomePagerDataBean) {
        var headerBean = bean.headerBean
        var focusListBean = headerBean?.focusList
        //临时缓存集合
        val cacheList = ArrayList<HomeHeaderBean.FocusListBean>()
        if (null != focusListBean && focusListBean.isNotEmpty()) {
            var imageViews = ArrayList<String>()
            //产品说取前8个
            if (focusListBean.size > 8) {
                cacheList.addAll(focusListBean.subList(0, 8))
            } else {
                cacheList.addAll(focusListBean)
            }
            for (item in cacheList) {
                imageViews.add(item.imageUrl!!)
            }
            banner_search.setImageLoader(GlideImageLoader(R.drawable.home_image_default_back))
                .setImages(imageViews).start()
            banner_search.setOnBannerListener {
                homeEvent?.bannerClick(cacheList!![it])
                YdlBuryPointUtil.sendClick(
                    "ydl-xinlizixun-home-banner$it",
                    "${cacheList[it].imageUrl}"
                )
            }
        }
    }

}