package com.yidianling.home.adapter

import android.content.Context
import android.util.Log
import android.view.View
import android.view.ViewGroup
import androidx.viewpager.widget.PagerAdapter
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import com.yidianling.home.ui.view.HomeCategoryContainer
import com.yidianling.home.ui.view.HomePagerBannerCategoryItemView
import java.util.*
import kotlin.collections.ArrayList

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/18
 */
class HomeCategoryAdapter : PagerAdapter {

    private var mContext : Context? = null
    private var mHomeEvent : IHomeBaseEvent? = null
    //源数据
    private var mOriginList : MutableList<HomeHeaderBean.AskCategoryDataBean>? = null
    //数据
    private var list : MutableList<MutableList<HomeHeaderBean.AskCategoryDataBean>>? = null

    init {
        list = ArrayList()
    }

    constructor(context: Context,homeEvent : IHomeBaseEvent?) : super(){
        mContext = context
        mHomeEvent = homeEvent
    }

    /**
     * 更新数据
     */
    fun updateItems(data : MutableList<HomeHeaderBean.AskCategoryDataBean>?){
        if (null == data || data.isEmpty()){
            return
        }
        Log.e("http","--------------data.size="+data!!.size)
        list = this.averageAssign(data, HomeCategoryContainer.PAGE_ITEM_SIZE)
        Log.e("http","--------------list.size="+list!!.size)
        notifyDataSetChanged()
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view === `object`
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val categoryView = HomePagerBannerCategoryItemView(mContext!!,mHomeEvent!!)
        categoryView.initData(list!![position])
        container.addView(categoryView)
        return categoryView
    }
    //====================ViewPager 不刷新问题====================

    override fun getItemPosition(`object`: Any): Int {
        return PagerAdapter.POSITION_NONE
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        container.removeView(`object` as View)
    }

    //====================ViewPager 不刷新问题====================

    override fun getCount(): Int {
        return list!!.size
    }

    fun <T> averageAssign(source : MutableList<T> , limit : Int) : MutableList<MutableList<T>>{
        if (null == source || source.isEmpty()) {
            return Collections.emptyList()
        }

        val result = ArrayList<MutableList<T>>()
        var value : MutableList<T> = ArrayList()
//        var yushu = source.size%limit
//        var quotient = source.size/limit
//        for (i in source.indices) {
//            value.add(source[i])
//            if ((i+1) % limit == 0){
//                result.add(value)
//                value = ArrayList()
//            }else if (i == source.size - 1){
//                result.add(value)
//            }else if ((i+1) > source.size - yushu){
//                value = ArrayList()
//            }
//        }
        for (i in source.indices) {
            if ((i + 1) % limit == 1){
                //新分组
                value = ArrayList()
            }

            value.add(source[i])
            if (i == source.size -1 || ( i + 1 ) % limit == 0){
                //列表最后一个或者为分组最后一个
                result.add(value)
            }
        }

        return result
    }
}